# Artificial Intelligence and Business Value: a Literature Review

Ida Merete Enholm1 & Emmanouil Papagiannidis1 & Patrick Mikalef1 & John Krogstie1

Accepted: 7 August 2021 / Published online: 25 August 2021   
$©$ The Author(s) 2021

# Abstract

Artificial Intelligence (AI) are a wide-ranging set of technologies that promise several advantages for organizations in terms off added business value. Over the past few years, organizations are increasingly turning to AI in order to gain business value following a deluge of data and a strong increase in computational capacity. Nevertheless, organizations are still struggling to adopt and leverage AI in their operations. The lack of a coherent understanding of how AI technologies create business value, and what type of business value is expected, therefore necessitates a holistic understanding. This study provides a systematic literature review that attempts to explain how organizations can leverage AI technologies in their operations and elucidate the valuegenerating mechanisms. Our analysis synthesizes the current literature and highlights: (1) the key enablers and inhibitors of AI adoption and use; (2) the typologies of AI use in the organizational setting; and (3) the first- and second-order effects of AI. The paper concludes with an identification of the gaps in the literature and develops a research agenda that identifies areas that need to be addressed by future studies.

Keywords Artificial intelligence $\cdot$ Systematic literature review $\cdot$ Research agenda $\cdot$ Artificial intelligence capabilities

# 1 Introduction

While Artificial Intelligence (AI) is not something new, it has gained much attention in recent years (Ransbotham et al., 2018). AI has been argued to be a force of disruption for businesses worldwide and in a wide range of sectors (Davenport & Ronanki, 2018). Organizations implementing AI applications are expected to attain gains in terms of added business value, such as increased revenue, cost reduction, and improved business efficiency (AlSheibani et al., 2020). A recent study by MIT Sloan Management Review found that more than $80 \%$ of organizations see AI as a strategic opportunity, and almost $85 \%$ see AI as a way to achieve competitive advantage (Ransbotham et al., 2017). In the search for competitive advantage, many organizations are thus investing in AI technologies. However, despite the growing interest in AI, many companies struggle to realize value from AI (Fountaine et al., 2019). The expected benefits of AI may be absent even though companies invest time, effort, and resources into the adoption process (Makarius et al., 2020).

The introduction of AI in organizational operations signals a new set of barriers and challenges (Duan et al., 2019). Some of these include bridging cross-domain knowledge to develop models that are accurate and meaningful (Duan et al., 2019), identifying, integrating and cleansing diverse sources of data (Mikalef & Gupta, 2021), and integrating AI applications with existing processes and systems (Davenport & Ronanki, 2018). To capture the potential value from AI, organizations need to understand how to overcome these challenges as well as the value-adding potential of these technologies. Yet, recent research on AI is more focused on a technological understanding of AI adoption than identifying the organizational challenges associated with its implementation (Alsheibani et al., 2020). While some studies have identified research gaps (Dwivedi et al., 2019), and looked at important aspects in being able to leverage AI technologies (Mikalef & Gupta, 2021), there is still a lack of a holistic understanding of how AI is adopted and used in organizations, and what are the main value-generating mechanisms.

In this paper we attempt to address this gap by providing a synthesis of the current body of knowledge and developing an agenda that can help advance our knowledge. We therefore perform a systematic collection of the extant literature, and put forward a narrative review by summarizing the existing body of literature and providing a comprehensive report which guides future studies (Templier & Paré, 2015). The objective of this paper is to identify in which ways organizations can deploy AI, and what value-generating mechanisms AI can enable. The first step in our study is collecting studies that examine organizational adoption and use of AI from 2010 onwards. After assessing the papers' relevance and quality, the remaining studies are analyzed and synthesized which lead to a framework form understanding AI business value. Based on the synthesis, a research agenda is created, identifying areas that need to be addressed by future research.

# 2 Research Methodology

The review was conducted in six distinct stages, following the established method of a systematic literature review in order to ensure that all relevant literature to date was included in our analysis (Kitchenham, 2004). First, the review protocol was developed which outlined the choice and structure of keywords and phrases. Second, the inclusion and exclusion criteria for relevant publications were identified in order to filter those publications that were of interest towards our review. Third, the search for papers was performed based on the pre-defined phrases as combinations of the keywords. The articles found in the search were critically assessed before performing data extraction and synthesizing the findings. The previously mentioned stages (Fig. 1) are described in further detail in the next subsections.

# 2.1 Protocol Development

The systematic literature review started by developing a review protocol following the method of the Cochrane Handbook for Systematic Reviews of Intervention (Higgins, 2008). In this protocol, the main research questions were established together with the search strategy, inclusion, exclusion, and quality criteria. The method of synthesis was also established in the protocol. The following research questions motivated the review process: What aspects enable or inhibit AI use in the organization? What are the types of AI uses in organizations? Through what mechanisms is AI value realized? These research questions formed the basis for deciding how to proceed in the next steps a what sets of keywords and data sources to utilize.

# 2.2 Inclusion and Exclusion Criteria

A number of inclusion and exclusion criteria were applied to set boundaries for the systematic literature review. Studies were included if they were focused on how AI can provide business value or how AI is adopted and used in an organizational context. This meant that studies that focused on solely technical aspects of AI, such as technical infrastructure or benchmarking of difference models were not in the scope of papers that were selected. Only publications from 2010 onwards were selected since the majority of organizational uses of AI, with novel methods, have been in the last decade. Studies not written in English were excluded from this review. In addition, the systematic literature review included journal articles and conference proceedings. Book series, dissertations, reports, and webpages were excluded, as were also other publications that were not peer-reviewed.

# 2.3 Data Sources and Search Strategy

The first step in the search strategy was to form search strings. Two sets of keywords were created (Appendix Table 8): the first set containing keywords related to AI and associated technologies, and the second set regarding the organizational perspective. Keywords from the two sets were combined to form the search string using wildcard symbols in order to reduce the number of search strings. The search terms were then applied in the search engine Google Scholar, as well as several other electronic databases such as Scopus, Business Source Complete, Emerald, Taylor & Francis, Springer, Web of Knowledge, ABI/inform Complete, IEEE Xplore, and the Association of Information Systems (AIS) library. This was done to ensure that all relevant articles had been indexed. The collection procedure started on September 14, 2020 and was concluded on September 30, 2020. To further ensure that the most important articles had been identified, we performed a separate search in the AIS basket of eight journals using the same sets of strings.

# 2.4 Quality Assessment

Two of the co-authors went through the papers independently after the eligibility check and assessed their quality in terms of several criteria. Studies were examined in terms of scientific rigor, credibility, and relevance. Scientific rigor meaning that the appropriate research method has been applied. Credibility refers to if the research is believable and the findings are well presented. Relevance refers to if the findings are relevant to the academic community and organizations engaging in AI projects. Together these quality criteria ensure that the papers remaining after this stage are likely to make a valuable contribution to the review. After this stage, 43 papers were left for data extraction and synthesis.

![](images/ca2890aae4660dde0940247d3e1548b56e7cd4f11f330ef2b1ec61fcc2fb5301.jpg)  
Fig. 1 Stages of the study selection process.

# 2.5 Data Extraction and Synthesis of Findings

A concept matrix was created in order to categorize the studies and synthesize findings. This was done by analyzing the papers and organizing information from the studies in a spreadsheet. Organizing the studies in this way makes it easier to make comparisons across studies and translate the findings into higher-order interpretations. The studies were analyzed based on the following areas of focus: organizational performance outcomes of AI, adoption, and use of AI in an organizational context, and organizational change caused by the adoption of AI. The information recorded included the research methodology, important definitions, level of analysis, key findings, theories used, context of investigation, and other important concepts from the paper. Two of the co-authors performed the data extraction based on the developed matrix, and then through an iterative process all co-authors reached a consensus about the context included in each category, and about adding additional dimensions to capture all relevant data. The remaining 43 papers were all analyzed and added to the concept matrix before the findings were synthesized.

# 3 Definitions

While AI has gained much attention in the last years due to the recent advancements in computer hardware, computer network speeds, the vast amount of available data, and processing algorithms (Alsheibani et al., 2020), there is considerable ambiguity about what the notion means and what it entails. The development of AI consists of several sub-disciplines based on fundamentally different approaches (Schmidt et al., 2020), and their meaning is often used interchangeably to encompass a broad set of technologies and applications (Dwivedi et al., 2019). Therefore, it is essential to draw a clear distinction between these core concepts and provide comprehensive definitions. We draw a distinction between three key areas of focuses: AI as a scientific discipline, technologies used to realize AI, and AI capabilities. These three levels provide a distinction between the discipline and its objective, the tools and technologies used to attain the goal, and the organizational capacity to use a set of diverse tools and technologies that support AI. In the sub-sections below, we present the definitions used in past research and provide a synthesis of the current body of knowledge.

# 3.1 Artificial Intelligence

Several definitions of AI have been published in an attempt to distinguish it from other conventional information technologies (Table 1). To understand the concept of AI, it is necessary to first understand the notions of "artificial" and "intelligence" separately. "Intelligence" can be described as involving mental activities, such as learning, reasoning, and understanding (Lichtenthaler, 2019). "Artificial", on the other hand, refers to something that is made by humans, rather than occurring naturally (Mikalef & Gupta, 2021). By combining these two together, Artificial Intelligence can be understood as making machines capable of simulating intelligence (WambaTaguimdje et al., 2020).

From the definitions in Table 1, it is evident that there is a consensus that AI refers to giving the computer human-like capabilities, meaning that computers are able to perform tasks that normally require human intelligence. This includes activities such as understanding, reasoning, and problem-solving (Mikalef & Gupta, 2021). AI emulates human performance by acting as an intelligent agent, which performs actions based on a specific understanding of input from the environment (Eriksson et al., 2020). In other words, the aim of AI is to try to reproduce human cognition by emulating how humans learn and process information. Cognitive technology is a term often used when referring to this capability. Cognitive technologies resemble the action of the human mind (Bytniewski et al., 2020),meaning that it provides the computer the function to think and act like a human.

In their definition, some scholars focus on the idea that AI should not need to be explicitly programmed to perform an intelligent task (Demlehner & Laumer, 2020). It should be able to sense, interpret, learn, plan, comprehend, and act on its own (Demlehner & Laumer, 2020; Kolbjørnsrud et al., 2017; Wang et al., 2019), meaning that AI should be able to correctly interpret external data, learn from this data, and use this learning to achieve specific goals and tasks through flexible adaption (Makarius et al., 2020). Doing so should be achieved without following predetermined rules or action sequences throughout the whole process (Demlehner & Laumer, 2020).

It is also identifiable that there are two main ways of defining AI. The first of these defines AI as a tool that solves a specific task that could be impossible or very time-consuming for a human to complete (Demlehner & Laumer, 2020; Makarius et al., 2020). The second group of definitions regards AI as a system that mimics human intelligence and cognitive processes, such as, interpreting, making inferences, and learning (Mikalef & Gupta, 2021). Both categories of definitions share some similarities but also present some important differences. A common notion in both categories is that AI does not necessarily replace humans, but instead, AI operates as an augmentation agent for performing difficult and time-consuming tasks (Mikalef & Gupta, 2021). Yet, both categories of definitions have some diverging points.

Table 1 Sample definitions of artificial intelligence   

<html><body><table><tr><td>Author(s) and date</td><td>Definition</td></tr><tr><td>Kolbjornsrud et al. (2017)</td><td>AI is defined as computers and applications that sense,comprehend,act, and learm.</td></tr><tr><td>Afiouni (2019)</td><td>AI is the general concept for computer systems able to perform tasks that usually need natural human intelligence,whether rule-based or not</td></tr><tr><td>Lee et al. (2019)</td><td>Artificial Intelligence: Intellgent systems created touse data,analysis,and observations to performcertain tasks without needing to be programmed to do so</td></tr><tr><td>Wang et al. (2019)</td><td>AI is a broad concept that captures the intelligent behavior of the machine</td></tr><tr><td>Makarius et al. (2020)</td><td>Artificial Intelligence: asystem&#x27;s capabilitytocorrectly interpret externaldata,to learn fromsuch data,and to use those learnings to achieve specific goals and tasks through flexible adaption</td></tr><tr><td>Schmidt et al. (2020)</td><td>Artificial Intelligence: The endeavor to mimic cognitive and human capabilities on computers</td></tr><tr><td>Demlehner and Laumer (2020)</td><td>Artificial Inteligence: a computer system having the ability to percept, leam, judge, or plan without being explicitly programmed to follow predetermined rules or action sequences throughout the whole process.</td></tr><tr><td>Wamba-Taguimdje et al. (2020)</td><td>Artificial Intelligence: defined as a set of &quot;theories and techniques used to create machines capable of simulating intelligence.AI is a general term that involves the use of computer to model intelligent behavior with minimal human intervention&quot;</td></tr><tr><td>Mikalef and Gupta (2021b)</td><td>AI is the ability of a system to identify,interpret,make inferences,and learn from data to achieve predetermined organizational and societal goals.</td></tr></table></body></html>

While one category of definitions assumes that AI is perfectly capable of imitating human behavior (Kolbjørnsrud et al., 2017; Wang et al., 2019), the second category of definitions regards AI as a tool, assuming it cannot exactly replicate human capabilities (Wamba-Taguimdje et al., 2020). Another noticeable difference is that some definitions refer to AI as a discipline of scientific inquiry (Schmidt et al., 2020), while others perceive the notion as an applied capacity of a system or machine (Afiouni, 2019; Lee et al., 2019). These definitions show that there are noticeable underlying assumptions, and some important differences about what AI is and what it encompasses. For the purpose of this article, we adopt the stance that AI is an applied discipline that aims to enable systems to identify, interpret, make inferences, and learn from data to achieve predetermined organizational and societal goals.

# 3.2 AI Technologies

Moving from the broad definition of what AI encompasses, the next level of definitions attempts to capture the techniques used to realize the objectives set in the previous definitions. Our analysis of the extant literature points out to the fact that this can be achieved through several different ways, with the largest proportion of studies focusing on cases where machine learning, and deep learning were being used. This section provides an overview of how some of the main types of AI technologies are defined in the literature, highlighting some key aspects of them, and outlining some important differences in terms of their application areas.

# 3.2.1 Machine Learning and Deep Learning

Machine learning is a subset of AI techniques, and one of the most widely used methods over the last few years. Machine learning has gained a lot of interest over the past few years, particularly due to the increase in data availability coupled with advances in computational power (Afiouni, 2019). Several definitions of machine learning exist in the literature, some of them shown in Table 2 as identified in our sample of papers. The objective of machine learning is to train a machine to be able to learn from data and make inferences, predictions, and identify associations, which can guide decisions (Afiouni, 2019; Wang et al., 2019). Machine learning techniques accomplish this by parsing data, learning for data, and making informed decisions based on what has been learned (Wang et al., 2019). This is an inductive approach in which decision rules are identified based on the collected data using statistical methods (Schmidt et al., 2020).

Machine learning algorithms can be further sub-divided into four categories: supervised, semi-supervised, unsupervised, and reinforcement learning (Wang et al., 2019). In supervised learning, the training data include the target value (Schmidt et al., 2020). The system then identifies patterns from the training data and infer its own rules from the labeled data (Afiouni, 2019). For unsupervised learning approaches, however, the target value is not included in the training set. The system has to analyze the structure of the training data and its statistical properties to solve the problem (Afiouni, 2019). Unsupervised learning is often used to discover hidden patterns in the data set with prominent applications being automatic clustering, anomaly detection, and association mining (Schmidt et al., 2020). In semi-supervised learning, both labeled and unlabeled data are used (Quinio et al., 2017). In contrast, reinforcement learning does not learn from past data (Afiouni, 2019). Rather, it enables learning from feedback received through interactions with an external environment (Quinio et al., 2017). The core idea is that the system has an objective set by a human agent and receives rewards based on how well the objective is met, which involves finding the best strategy or combination of actions (Afiouni, 2019).

Machine learning can be either shallow or deep. All four training categories apply to both shallow and deep machine learning. Shallow-structured learning architectures are the most traditional, where it learns from data described by predefined features (LeCun et al., 2015). In contrast, deep machine learning, usually referred to as deep learning, can derive structure from data in a multi-layered manner (Wang et al., 2019). What differentiates deep learning from the more traditional machine learning is the use of an artificial neural network architecture (Afiouni, 2019; Wamba-Taguimdje et al., 2020) Neural network solutions refer to the human brain’s functionality (Jelonek et al., 2019) by imitating human neurons (Schmidt et al., 2020). Deep learning is based on creating deep neural networks with several hidden layers, where the layer closest to the data vectors learns simple features, while the higher layers learn higher-level features (Quinio et al., 2017). It represents the world through a hierarchy of concepts, in which each concept can be divided into more straightforward concepts (Borges et al., 2020). In recent years, deep learning has become an area with considerable attention due to its many use cases and its ability to produce remarkably accurate results in various domains (Wang et al., 2019).

# 3.2.2 Other AI Technologies

While machine learning applications appear to be dominating the research interest in the Information Systems (IS) domain, there are also several other key AI technologies that have been examined in empirical studies and are presented in Table 3. Today, most of these technologies are used in combination with machine learning or deep learning, to provide solutions that to evolve and learn. For instance, in the case of chatbots both natural language processing (NLP) and machine learning are applied (Baby et al., 2017). The functionality enabled through NLP allows chatbots to understand and communicate using the human language. On the other hand, the machine learning algorithms facilitate chatbots to learn and evolve as they get access to more data (Castillo et al., 2020). Other notable types of AI technologies studies in IS empirical works are presented in Table 3.

Table 2 Sample Definitions of Machine Learning   

<html><body><table><tr><td>Author(s) and date</td><td>Definition</td></tr><tr><td>Wang et al. (2019)</td><td>Machine learning empowers the machine to &quot;learn&quot; without explicit programming. This learning process is accomplished by machine itself through collecting data,analyzing data and making predictions.</td></tr><tr><td>Wang et al. (2019)</td><td>The principle of machine learning incorporates training algorithms to enable machines to learn how to make accurate predictions.There are four training categories of machine learning algorithms: supervised,semi-supervised,unsupervised and reinforcement.</td></tr><tr><td>Afiouni (2019)</td><td>Machine learning is that subset ofAI that is capable of&quot;learming from data and making predictions and/or decisions&quot; without human dictated rules.</td></tr><tr><td>Schmidt et al. (2020)</td><td>Machine learning uses an inductive approach in which decision rules are identified based on collected data using statistical methods.</td></tr><tr><td>Wamba-Taguimdje et al. (2020)</td><td>Machine Learning -automatic learning: machine &#x27;learn&#x27; from the datasets offered to them</td></tr></table></body></html>

# 3.3 AI Capabilities

While the previous definitions concern the broader quest of what AI aims to achieve, as well as the methods and technologies used to actualize these objectives, the notion of an AI capability is revolved around the organizational capacity to deploy such applications in support of operations (Mikalef & Gupta, 2021). With AI becoming an increasingly important asset for organizations, there is a growing body of research examining how such technologies and techniques can be leveraged towards the attainment of organizational goals (Bytniewski et al., 2020; Schmidt et al., 2020; Wang et al., 2019). The notion of an AI capability has thus been introduced to explain how this value is achieved, and how organizations should be organized in order to realize value from AI investments.

While there are still few studies adopting an analysis of AI from the focus point of an organizational capability, there is growing body of research building on this concept as presented in Table 4. The definitions differ slightly but all encompass what an organization should be able to do with AI investments, while some also include the desired outcomes of deploying an AI capability. The definition of Schmidt et al. (2020) for instance belongs to the latter category, as they define AI capabilities as "the ability of organizations to use data, methods, processes and people in a way that creates new possibilities for automation, decision making, collaboration, etc. that would not be possible by conventional means". This definition includes not only data and methods, but also the people and processes required to orchestrate and leverage AI into action. Similarly, other definitions include complementary resources that are required to reap the benefits provided by AI technologies (Wamba-Taguimdje et al., 2020). All definitions through converge in that they have an underlying notion that an AI capability is about how an organization uses its AIspecific resources in order to enable value creation (Schmidt et al., 2020; Wamba-Taguimdje et al., 2020). These AIspecific resources can be both technological, e.g. training data and AI-algorithms (Schmidt et al., 2020), and non-technical, e.g. employee skills (Wamba-Taguimdje et al., 2020). Hence, the notion of AI capability extends the view of AI to not only focus on the technical resources, but also include all related organizational resources that are important in order to exploit the full strategic potential of AI.

Table 3 Definition of other AI Technologies   

<html><body><table><tr><td>Technology</td><td>Definition</td><td>Reference(s)</td></tr><tr><td>Natural language processing (NLP)</td><td>NLP: the process through which machines can understand and analyze language as used by humans.</td><td>Jarrahi (2018)</td></tr><tr><td>Computer vision</td><td>Computer vision: Algorithmic inspection and analysis of images.</td><td>Jarrahi (2018)</td></tr><tr><td>Expert system</td><td>Expert systems are directed at imitating human decision-making by capturing and representing the expertise of experts for other organizational members to use,serv- ing as a knowledge base.</td><td>Afiouni (2019); Lichtenthaler (2019)</td></tr><tr><td>Planning and scheduling</td><td>The development of action strategies and sequences for subsequent execution</td><td>Lichtenthaler (2019)</td></tr><tr><td>Speech synthesis systems</td><td>Includes text-to-speech and speech-to-text solutions.舃Text-to-speech: the production</td><td>Lichtenthaler (2019)</td></tr><tr><td></td><td>of speech by machines,by automatic con-</td><td>Damper et al. (1999)</td></tr><tr><td></td><td>version of text to a phonemic specification of pronunciation of the sentences to utter. Speech-to-text systems takes a human speech</td><td>Ghadage and Shelke (2016)</td></tr></table></body></html>

Table 4 Sample definitions of AI capability   

<html><body><table><tr><td>Author(s) and date</td><td>Definition</td></tr><tr><td>Schmidt et al. (2020)</td><td>AI capability: The ability of organizations to use data,methods,processes and people in a way that creates new possibilities for automation,decision making,colaboration,etc.That would not be possible by conventional means.</td></tr><tr><td>Schmidt et al. (2020)</td><td>AI-capabilities are digital capabilitis tat integrate A-specificaets,forinstane,AI-algorithms, training data, etc. in order to enable value creation.</td></tr><tr><td>Wamba-Taguimdje et al. (2020)</td><td>AIcapabilities could be defined as the firm&#x27;s ability to createa bundle oforganizational, personnel,and AI resources for business value creation and capture.</td></tr><tr><td>Mikalef and Gupta (2021)</td><td>An AI capability is the abilityofa firm to select, orchestrate,and leverage its AI-specific resources.</td></tr></table></body></html>

turn, we develop two broad categories of AI use in organizations and summarize the current knowledge regarding the applications within these categories. Next, we differentiate the impacts of AI into first-order effects and second-order effects. These represent impacts that materialize at the process and firm levels respectively. We therefore argue that secondorder effects need to be examine first through the first-order effects they stem from. The section is structured in accordance with the organizing framework, concluding with an overview of theories that have been used in the study of AI and business value.

# 4.1 Enablers and Inhibitors of AI Use

Based on the clustering of the context of papers, we find that enablers and inhibitors can be subdivided into three main categories: technological, organizational, and environmental. Based on this categorization we discuss what the current body of research and what we know so far about aspects that either accelerate AI deployments or generate obstacles for use. The findings are summarized in Table 5 and discussed below.

# 4 Synthesis of Literature Review

This section presents the findings from the systematic literature review, structured according to the thematic codes that emerged during the analysis of past studies. The findings were obtained through an analysis process following the research methodology. To be able to assess the body of knowledge on AI and business value, we differentiated between three interdependent levels, which are depicted in Fig. 2. In this organizational framework we show that there are several important factors relating to the technological readiness, organizational aspects, and environmental factors that have an important impact on the ability of organizations to deploy and utilize AI. In

# 4.1.1 Technological

Data At the core of AI is data. Large data sets are used to train the AI (Pumplun et al., 2019; Schmidt et al., 2020). AI learns to make decisions based on these data sets, rather than based on an explicitly defined set of rules defined by expert knowledge (Pumplun et al., 2019; Schmidt et al., 2020). Therefore, an essential enabler of AI adoption in organizations is the data they produce, e.g., sensor data (Demlehner & Laumer, 2020), or have access to (Mikalef & Gupta, 2021). The term big data is often used to refer to these large data sets. According to Beyer and Laney (2012), big data is "high-volume, high-velocity, and/or high-variety information assets that require new forms of processing to enable enhanced decision making, insight discovery, and process optimization" (Mikalef et al.,

![](images/d138be0e5bcb8dbbeb5b835105609b895fb815055eb9db8516299106722a7d76.jpg)  
Fig. 2 Organizational framework of AI and business value

2018). This definition captures big data’s main characteristics, namely the "three Vs": volume, velocity, and variety. To develop high-quality AI applications, large volumes of training data have to be available (Afiouni, 2019; Keding, 2020; Pumplun et al., 2019; Schmidt et al., 2020). A common challenge when using AI is the lack of enough training data (Baier et al., 2019). Velocity, or timeliness, refers to the speed at which the data are collected and updated (Gregory et al., 2020; Mikalef et al., 2018). Timeliness affects AI systems that heavily rely on the freshness of data, e.g., time-series forecasting. In addition, having a wider range of variety in the training data broadens the model’s ability to make predictions, thus increasing its accuracy (Wang et al., 2019).

Another critical aspect of the data used to train the AI is the quality of the data (Alsheiabni et al., 2018; Baier et al., 2019; Demlehner & Laumer, 2020; Lee et al., 2019). Data quality is crucial for providing reliable predictions (Alsheiabni et al., 2018). "Garbage-in, garbage-out" is a fundamental principle for AI (Lee et al., 2019), meaning that if training data has low quality, the insights generated by the AI will also be of low quality and not useful in the organizational context. Common problems regarding the data’s quality include incomplete data, incorrect entries, and noisy features (Baier et al., 2019). Recognizing these quality problems can be quite challenging. Thus, data scientists and domain experts need to collaborate closely to identify data quality problems (Baier et al., 2019). An important aspect of quality also relates to using data that are free from bias and follow responsible and trustworthy principles. Bias can be introduced in the used data at different points, such as during the generation or collection, or even during the processing. Ntoutsi et al. (2020) propose a number of methods in their work in order to understand, mitigate, and account for bias in order to reduce negative consequences. Such bias stems not only during the generation or collection, but is also a result of annotation, when data is assigned semantic meaning (Geva et al., 2019). Hence, we see that from the body of empirical studies that data characteristics are multifaceted, and are a core requirements in order to be able to actualize AI applications (Afiouni, 2019; Mikalef & Gupta, 2021).

Technology infrastructure A complementary and equally important aspects for organizations is having the right technology infrastructure for adopting AI AlSheibani et al., 2020). To successfully deploy AI in an organization, three things are needed: computing power infrastructure, algorithms, and rich data sets (Wamba-Taguimdje et al., 2020). AI algorithms build models based on the data. These algorithms can be complex, and the data sets can be enormous. Therefore, the infrastructure could require massive amounts of computing power (Baier et al., 2019; Wamba-Taguimdje et al., 2020). In other words, having high speed and being ‘infinitely’ scalable (Wamba-Taguimdje et al., 2020). It is not feasible for many companies to have these resources on-site (Schmidt et al., 2020). Large companies, such as Google, Amazon, and Microsoft, have thus started to provide infrastructure for machine learning in the cloud (Borges et al., 2020), e.g., Google Cloud AI. These solutions give other organizations online access to the infrastructure necessary for adopting AI (Borges et al., 2020; Schmidt et al., 2020; Wang et al., 2019). Therefore, to adopt AI, companies either need access to a cloud-based solution or have the right computational hardware to facilitate the use of AI on their own.

<html><body><table><tr><td>Calegory</td><td>Aspects</td><td></td><td></td></tr><tr><td>Technological</td><td>Data</td><td>· Availability</td><td>Afiouni (2019); Alsheiabni et al. (2018); Baier et al. (2019); Demlehner Laumer (2020); Keding (2020); Pumplun et al. (2019); Schmidt et al.</td></tr><tr><td></td><td></td><td>· Volume</td><td>Afiouni (2019); Keding (2020); Pumplun et al. (2019); Schmidt et al. (2</td></tr><tr><td></td><td></td><td>· Velocity</td><td>Gregory et al. (2020)</td></tr><tr><td></td><td></td><td> · Variety/diversity</td><td>Wang et al. (2019)</td></tr><tr><td></td><td>Technology infrastructure</td><td>· Quality</td><td>Alsheiabni et al. (2018); Demlehner &amp; Laumer, (2020),Baier et al. (201</td></tr><tr><td></td><td></td><td>· Computing power</td><td>Baier et al. (2019), Wamba-Taguimdje et al. (2020)</td></tr><tr><td></td><td></td><td> · Cloud infrastructure</td><td>Wang et al. (2019), Schmidt et al. (2020), Borges et al. (2020)</td></tr><tr><td>Organizational</td><td></td><td>· Algorithms</td><td>Wamba-Taguimdje et al. (2020)</td></tr><tr><td></td><td>Culture</td><td></td><td>Pumplun et al. (2019), Lee et al. (2019)</td></tr><tr><td></td><td> Top management support</td><td></td><td>Alsheiabni et al. (2018),Demlehner and Laumer (2020),AlSheibani et a</td></tr><tr><td></td><td>Organizational readiness</td><td>·Financial resources</td><td>Pumplun et al. (2019)</td></tr><tr><td></td><td></td><td>· Employee sills</td><td>Alsheibani et al. (2020), Pumplun et al. (20192019)</td></tr><tr><td></td><td>Employee-AI trust</td><td></td><td>Makarius et al. (2020),Keding (2020)</td></tr><tr><td></td><td>AI strategy</td><td></td><td>Keding (2020), Finch et al. (2017)</td></tr><tr><td></td><td>Relative advantage</td><td></td><td>AlSheibani et al., (2020)，Alsheibani et al. (2018)</td></tr><tr><td></td><td>Compatibility</td><td></td><td>Pumplun et al. (2019),Alsheiabni etal. (2018), AlSheibani et al., (2020)</td></tr><tr><td>Environmental</td><td>Ethical and moral aspects</td><td></td><td>Coombs et al. (2020),Alsheibani et al. (2020), Baier et al. (2019)</td></tr><tr><td></td><td>Regulations</td><td>· Governmental policies and regulations</td><td>Baier et al. (2019), Pumplun et al. (2019)</td></tr><tr><td></td><td></td><td>· Industry requirements</td><td>Coombs et al. (2020), Pumplun et al. (2019)</td></tr><tr><td></td><td>Environmental pressure</td><td>· Competitive pressure</td><td>AlSheibani et al., (2020),Demlehner and Laumer (2020), Pumplun et al</td></tr><tr><td></td><td></td><td>·Customer pressure/ readiness</td><td>Pumplun et al. (2019)</td></tr></table></body></html>

# 4.1.2 Organizational

Organizational enablers and inhibitors of AI are concerned with how the organizational context, such as strategic orientation and organizational structure, affects the organization’s ability to adopt AI successfully.

Culture The culture in the company is argued in research to be a strong force in the decision to adopt AI (Mikalef & Gupta, 2021; Pumplun et al., 2019). AI can be seen as an innovative technology, possibly changing the company’s business model and systems (Lee et al., 2019). Thus, the organization must be able to respond to this change. This includes having employees willing to use the new technology in the long run (Pumplun et al., 2019). Innovative cultures have a passion for and willingness to exploit new, opportunistic ideas, and are therefore more likely to embrace AI technologies (Mikalef & Gupta, 2021). Having employees who are continuously willing to learn and innovate will support the deployment and use of AI applications (Lee et al., 2019). This is because employees with an innovative mindset are more open to using a new technology, as well as being able to identify and seize new opportunities for applications of AI. Therefore, organizations with an innovative culture are posited to be better positioned to integrate AI in their work line (Mikalef & Gupta, 2021).

Top Management Support One of the strongest determinants of AI adoption, and a recurrently noted aspect is top management support (Alsheiabni et al., 2018; AlSheibani et al., 2020; Alsheibani et al., 2020; Demlehner & Laumer, 2020). Adopting AI is a complicated process where many challenges must be faced, organizational as well as technological. Top managers and business owners should thus take part in exploring AI technologies and not leave this solely to the technologists (Alsheibani et al., 2020). For example, a company’s culture has shown to influence AI adoption, as discussed above, and top managers play a crucial role in establishing this culture (Lee et al., 2019). Also, top-level management can support the adoption of AI by allocating resources and providing capital funds (AlSheibani et al., 2020). The dedication and engagement of top-level management is thus suggested to be a strong contributor towards organizational AI deployment

Organizational Readiness Organizational readiness refers to the availability of the complementary organizational resources needed for AI adoption (Alsheiabni et al., 2018; AlSheibani et al., 2020). As with other innovations, the adoption of AI requires financial resources through a dedicated budget (Pumplun et al., 2019). A high budget, with no obligations to meet specific performance targets, is suggested to enable the adoption of AI, as employees have the ability to learn while working with the development of AI solutions (Pumplun et al., 2019). Additionally, the implementation of AI is heavily dependent upon the skills of the organization’s human resources. Adopting new technology may lead to new skill requirements. Organizations adopting AI need employees with technical skills to create and deploy AI systems, e.g., they should be able to utilize technical AI libraries such as TensorFlow, PyTorch, or Keras (Pumplun et al., 2019). They also need domain experts who understand the tasks, workflows, and logic of the existing business processes and have the ability to consider how AI systems can improve them (Alsheibani et al., 2020; Pumplun et al., 2019). An evaluation of the internal availability of expertise is thus required in order to ensure that technical employees, as well as managerial staff know not only how to utilize such novel tools and technologies, but also for what business functions they should be targeted towards (Mikalef & Gupta, 2021).

Employee-AI Trust AI systems have been shown to be able to perform tasks that replicate human cognition or automate previously manual tasks (Zheng et al., 2017). In many of these cases, humans were the ones responsible for carrying out such tasks, and the implementation of AI can consequently change the roles of the organization’s employees. Roles may need to be redesigned, and new roles can emerge. Thus, the employees need to understand the purpose of AI, what role it will play, and how it will change the employee’s role and responsibilities within the organization (Makarius et al., 2020). Employees possibly have to co-work or base their decisions based on AI systems. This means that they have to trust the AI system, and have an understanding about how they operate and reach conclusions (Makarius et al., 2020). The interaction between humans and AI is a complex process and building trust between humans and machines can be difficult. AI does not experience emotions the same way as a human does, and neither does it have the same empathy capabilities (Makarius et al., 2020). Employee-AI trust can thus be an inhibitor of AI use, with employees causing strong inertial forces to change. The problem of trust however, also applies to managers since they need to know that AI will operate according to the design directives. A manager’s willingness to trust an AI system is related to the degree to which there is an understanding of the technology (Keding, 2020).

AI Strategy To reap the benefits of AI, organizations should develop an AI strategy (Finch et al., 2017a; Keding, 2020). The strategy should describe how the organization will adopt and implement AI in order to utilize its benefits. The actions described should align with the company’s existing goals (Keding, 2020). AI strategies are not merely stating what the organization would like to achieve with the implementation of AI, but also provide specific processes, plans, and timeframes for actualizing these objectives. In addition, an AI strategy is likely to require considerable modifications to how the organization is structured, the level of collaboration between departments, as well as how data is governed throughout the organization (Mikalef & Gupta, 2021). Thus, it is essential first to define the relative advantage and compatibility of the AI solution to organizational goals and strategy.

Compatibility Compatibility refers to the fit between the desired application and technology (Pumplun et al., 2019). A stronger fit between the technology and the task will lead to higher levels of adoption and use (Mishra & Pani, 2020). The compatibility concept can be divided into two subcategories: business processes and business case (Pumplun et al., 2019). A concrete, solid business case has to be formulated and aligned with existing strategies (Alsheiabni et al., 2018; AlSheibani et al., 2020; Pumplun et al., 2019). This means defining an exact problem that the adoption of AI is intended to solve (Pumplun et al., 2019). A solid business case should describe what the AI technology will do and demonstrate how its algorithms will enhance business processes’ execution and outcomes (Alsheiabni et al., 2018). When adopting AI, new requirements will arise. The company’s business processes must be adapted to these new requirements for the adaption to be successful (Pumplun et al., 2019).

# 4.1.3 Environmental

Organizations operate in dynamic and constantly changing environments, consisting of actors such as competitors and government, that have an influence on how the organization can and should conduct business. This, in turn, exerts different types of pressure on the organization’s ability and propensity to adopt AI. This section presents environmental enablers and inhibitors of AI use.

Ethical and Moral Aspects Ethical and moral aspects are essential aspects when adopting AI. AI systems have humanlike abilities, which means that the boundaries between humans and machines become less transparent. Thus, the organization must ensure that AI applications have been developed based on ethical principles and do not embed within them unknown biases (S. A. Alsheibani et al., 2020; Baier et al., 2019; Coombs et al., 2020). AI ethics have been defined as "... a set of values, principles, and techniques that employ widely accepted standards of right and wrong to guide moral conduct in the development and use of AI technologies" (Alsheibani et al., 2020). AI ethics can help organizations make sure that their use of technology aligns with their values. Transparency, bias, and discrimination are some of the challenges that emerge when developing AI systems (Alsheibani et al., 2020; Baier et al., 2019). AI is data-driven, thus it can lead to potentially biased and discriminatory outcomes if the underlying data set is imbalanced or discriminatory (Baier et al., 2019). It can also replicate the biases and preconceptions of the system designer. In fact, there have been several reports on prominent companies such as Apple and Amazon, on misuse of AI which resulted in discrimination and bias (Dastin, 2018; Vigdor, 2019).

In taking a more holistic perspective on ethical and moral aspects surrounding AI, several public and private bodies have initiated working groups with the aim of defining key principles that should underlie AI use (European Commission, 2019a). A recent report published by the European Commission, highlights seven key dimensions that organizations should consider when deploying AI applications (European Commission, 2019b). These go beyond aspects related to bias, and include dimensions such as transparency of AI applications, accountability, safety and security, societal and environmental well-being, design for universal access, and human agency and oversight. The purpose of reports such as the above and other empirical works is to minimize the potential risks faced by organizations (Arrieta et al., 2020), and to ensure that AI applications enact behaviors that are more ethically correct than humans (Coombs et al., 2020). Building on such principles is also argued to help organizations balance between black-box and white-box AI applications, or in other words, finding the right equilibrium between accuracy and interpretability (Loyola-Gonzalez, 2019; Wanner et al., 2020).

Regulations Government policies and regulations manifest the social attitudes on ethical and moral issues, and provide directives that shape how AI applications are developed. In May 2018, the General Data Protection Regulation (GDPR) was enforced in the European Union (EU) and the European Economic Area (EEA). GDPR regulates activities such as the processing of personal data. This new law has caused some issues for organizations employing AI solutions as they struggle to provide personal data to use in the training of their intelligent machines (Pumplun et al., 2019). Many data sets need to be anonymized to handle these new legal requirements, which makes the use of intelligent, self-learning algorithms more difficult or even impossible (Pumplun et al., 2019). GDPR increases the complexity of the deployment of AI (Baier et al., 2019; Pumplun et al., 2019) and can thus can lead to inhibited AI adoption. Other legal aspects that can prove to hurdles in the adoption of AI concern the intellectual property entailed in AI algorithms and the data sets used by it (Baier et al., 2019; Demlehner & Laumer, 2020). In addition to the governmental regulations, each industry has its own set of requirements that affect AI adoption (Coombs et al., 2020; Pumplun et al., 2019). This can be laws or other external circumstances that affect the company and its interaction with the environment (Pumplun et al., 2019). Highly regulated sectors, such as healthcare, may encounter additional challenges in deploying AI compared to less regulated sectors (Coombs et al., 2020).

Environmental Pressure An important driver of AI adoption is competitive pressure (AlSheibani et al., 2020; Demlehner & Laumer, 2020; Pumplun et al., 2019). Competitive pressure refers to how an organization is affected by its competitors and the action taken in response to these. Attainting a competitive advantage over rivals, means that organizations have to take action in order to reconfigure and adapt based on continuous and rapid change. The threat of losing a competitive advantage therefore acts as a force in motivating organizations to adopt IT innovations (AlSheibani et al., 2020). Competitive pressure can thus make organizations more prone to adopt AI in order to gain or maintain a competitive advantage. On the other hand, there is also a strong pull for the demand side. Customers are the ones who purchase goods and services from a company, which required that organizations need to meet and exceed the needs of its customers. When a company decides to adopt AI, it is also essential to consider its customer base’s knowledge and acceptance (Pumplun et al., 2019). Customers are increasingly expecting individualized services and products, such as the recommendation engine of Netflix. This will push the companies to adopt AI in order to design individualized, intelligent products (Pumplun et al., 2019).

# 4.2 AI Use

The applications of AI span several diverse areas, such as marketing, production management, enterprise management, and customer service (Alsheiabni et al., 2018; Jelonek et al., 2019). AI applications can be deployed across the entire value chain of an organization, and it has the potential to revolutionize many key aspects of our daily lives (Wamba-Taguimdje et al., 2020). AI applications depending on their use can be divided very broadly into two categories: AI for automation and AI for augmentation. Automation refers to AI systems that are tasked in replacing human work, while augmentation enhances human intelligence by providing insight that can aid decision-making. Both automation and augmentation have applications in many organizational processes, or affect the organization’s customers through new or improved products and services that implement AI.

# 4.2.1 Automation

The notion of automation is not something new, it is an established concept relating to machines replacing humans, such as robots performing tasks on an assembly line. This description is true also for the automation enabled by AI, but it does not describe the radical changes that AI causes. Recent advances in AI have enabled machines to learn, improve, and adapt, thus increasing performance over time (Coombs et al., 2020). Therefore, AI technologies are able to automate more complex tasks involving cognition, such as learning and problem-solving (Lee et al., 2019). This automation is often called Intelligent Automation (Welling, 2019). Intelligent Automation enables the automatization of tasks that were previously considered too difficult to automate, such as knowledge and service work (Coombs et al., 2020). An example is the use of virtual robots to automatically process emails (Wamba-Taguimdje et al., 2020).

In the manufacturing and construction industries, AI is used to automate budgeting and planning, as well as inventory and replenishment (Wamba-Taguimdje et al., 2020). In the service context, AI can provide customers with digital and robot services to influence their customer experience (Prentice et al., 2020). An example of this is chatbots, which are conversational software systems that emulate humans’ communication capabilities (Nuruzzaman & Hussain, 2018). Chatbots can assist customers through a voice or text interface (Castillo et al., 2020). In the credit card insurance industry, chatbots are used to answer basic questions, resolve insurance claims, sell products, and ensure that the customers are adequately covered by their insurance (Nuruzzaman & Hussain, 2018). Chatbots are thus doing a job that was previously occupied by a human employee.

In addition to using AI for automating tasks within an organization, it can also create new or enhanced products and services to automate tasks for the customers. An example of this is conversational intelligent agents, such as Apple’s Siri and Amazon’s Alexa (Castillo et al., 2020; Prentice et al., 2020), which can automate tasks such as writing texts, making calls, and starting a playlist through voice commands. These agents can also be coupled with devices, such as Arduino and Raspberry Pi, to provide smart home automation through voice interaction (Matei & Iftene, 2019). This type of systems can automate simple day-to-day tasks at home, e.g., interactions with TV and lights. Another example is the introduction of facial recognition in smart phones, which automates the process of user authentication. These examples show the multitude of potential applications of AI, and the diversity of areas in which they can be used to automate tasks.

# 4.2.2 Augmentation

In recent years, AI has exceeded humans in performing certain complex tasks (Jarrahi, 2018). AI can process large amounts of information at high speed beyond humans’ cognitive capabilities (Jarrahi, 2018). Hence AI can be used to overcome the cognitive limitations of humans. Augmentation refers to integrating AI with human expertise to enhance decisions and optimize actions (Schmidt et al., 2020). The focus is on AI’s assistive role, indicating that it supports humans rather than replacing them.

Organizations often produce or have access to vast amounts of data. By considering this data, managers can make better-informed decisions. However, the data are often too complex to be analyzed by a human. Thus, managers can use AI to gain insights through data for better decisionmaking (Borges et al., 2020). Predictive analytics can learn from data and make accurate predictions and transaction-level decisions (Makarius et al., 2020). Possible use cases include interpreting previously unknown management control indicators and proposing corrective actions when sales decrease and the competition introduces new products (Bytniewski et al., 2020). AI can also be used in the analysis of opinions, attitudes, and emotions related to a particular product or a service (Jelonek et al., 2019), which is becoming more and more critical for organizations as they can get detailed insight to how their customers perceive their offerings (Bytniewski et al., 2020; Davenport & Ronanki, 2018).

In healthcare, computer vision vision can be used to process MRI images of the brain to mark tiny hemorrhages in the images for doctors (Jarrahi, 2018). AI can also detect cancer patterns (Jarrahi, 2018) or create surgical robots that can assist physicians during complicated surgeries (Makarius et al., 2020). In public relations, AI can be used to monitor social media and predicting media trends (Galloway & Swiatek, 2018). In marketing, AI can be applied to customer segmentation to classify customers based on preferences and lifestyle (Mishra & Pani, 2020). In fashion industries, AI is used to anticipate customer habits, predict future trends, and optimize recommendation systems (Wamba-Taguimdje et al., 2020).

AI can also be applied to products and services that organizations offer to enhance their customer’s intelligence. An example is Netflix’s recommendation engine, which uses various parameters based on the customer data, such as location, content watched, and the data searched by the user, to give personalized recommendations (Netflix (2020). Machine Learning, 2020-12-03). These personalized recommendations increase the likelihood of customers choosing to watch something they genuinely will like.

# 4.3 Impacts of AI

The question of how AI can lead to competitive performance is of interest to every business executive. To answer this question, the impacts of AI at both the process- (first-order) and firm-levels (second-order) should be studied. How does AI change business processes, and how does this lead to competitive performance? The next subsections address the first- and second-order impacts of AI.

# 4.3.1 First-Order Impacts

The first order effects of AI use are related to the changes it causes at the process level of an organization. Key performance indicators (KPIs) concerned with efficiency, effectiveness, capacity, productivity, quality, profitability, competitiveness and value are common measures of the performance improvements at the process level, and are used to monitor the output of an organization (Wamba-Taguimdje et al., 2020). To assess the impacts of AI on the process level, three different effects are discussed: process efficiency, insight generation and business process transformation.

Process Efficiency Using AI to automate tasks or augment human intelligence in organizations can improve business process performance by increasing efficiency indicators (Coombs et al., 2020; Kirchmer & Franz, 2019). Automation of tasks through AI involves replacing human work with a machine. By automating tasks, organizations may relieve some employees of repetitive routine tasks, which enables them to focus on other knowledge-intensive activities that add more value to the organization (Makarius et al., 2020), thus increasing their productivity (Balasundaram & Venkatagiri, 2020; Bauer & Vocke, 2019; Bytniewski et al., 2020; Finch et al., 2017a). Moreover, machines can perform tasks quicker and with greater precision than humans, increasing organizations’ throughput, particularly in manufacturing industries and supply chain operations (Balasundaram & Venkatagiri, 2020; Finch et al., 2017a). Furthermore, AI use can reduce the time required to complete some key business processes (Coombs et al., 2020), and improve the error-rate and lag times by automatizing a series of tasks (WambaTaguimdje et al., 2020). For example, using AI in car manufacturing to automate visual recognition of barcodes and license plates improves efficiency compared to when performed by a human employee (Demlehner & Laumer, 2020). The replacement of human work by machines also includes reducing or eliminating errors made by human employees, and increasing transparency. Consequently, the quality of the results is suggested to be improved (Finch et al., 2017b).

Insight Generation One of the most prominent first-order effects of AI is that it can unlock insight and patterns hidden in large volumes of data (Mikalef & Gupta, 2021). By collecting, processing, and disseminating data within and between organizations, AI can present previously unknown information and help make insight-driven decision (Jelonek et al., 2019). According to Lichtenthaler (2019), "Even if two firms have access to the same internal and external knowledge, they may achieve different competitive positions if one firm has superior intelligence that enables specific insights as a basis for targeted competitive moves that the other firms lacks". This suggests that organizations should foster ways by which they can leverage AI in order to gain insight that their competitors lack (Lichtenthaler, 2019).

The hidden value unlocked by AI can be used to make better-informed decisions, or even to partially automate tasks.

AI can assist managers overcome their cognitive limitations by providing an efficient way to handle the large volumes of data available (Finch et al., 2017a; Keding, 2020). When decision-makers have access to more detailed knowledge, the quality and speed at which decisions are taken will increase (Keding, 2020). AI, therefore, enables faster and better decision-making (Wang et al., 2019). Organizations that can exploit AI’s informational effects are better positioned to quickly sense and respond to market dynamics (WambaTaguimdje et al., 2020). This capability of responsiveness is also known as organizational agility, and it consists of sensing, informed decision-making, and responding (Wang et al., 2019). AI, and deep learning, in particular, can play an active role in each of these activities. Specifically, AI applications can be steered towards systematically and effectively identifying patterns and underlying signals that humans may miss (Eriksson et al., 2020), and be trained to respond to these signals fast and accurately (Wang et al., 2019).

Business Process Transformation As an innovative and (often) disruptive technology, AI enables organizations to innovate and transform business processes (Wamba-Taguimdje et al., 2020). The goal of all business processes is to convert inputs into valuable outputs, and new technology is expected to improve these processes through radical transformation (Mishra & Pani, 2020). AI is no exception, as it can enable the redesign of business processes with the intention of radically changing how current operations are executed (Mishra & Pani, 2020). Through this process, AI is also a driver for re-engineering and redesigning the existing organizational structure (WambaTaguimdje et al., 2020). It influences how human resources are being used, facilitating change in business processes and the organizational structure. The implementation of AI brings a new set of skills and capabilities for managers, employees, and AI to work together (Makarius et al., 2020). As a consequence, jobs may need to be redesigned, and new jobs can emerge. By using AI, organizations can reallocate resources, which, in the long term, have the potential to redraw the organizations’ organizational chart (Eriksson et al., 2020). In other words, the transformational effects of AI on business processes can be either direct, or indirect.

introduction of new products and services and enhancing the quality of existing products and services.

Introduction of new products and services One way of reaping the benefits of AI is for companies to identify opportunities to enter the market with a new offering (Mishra & Pani, 2020). AI can search through massive amounts of data to find patterns that can show opportunities for introducing new products and services. For example, by discovering shifts in customer preferences, organizations can find opportunities for entering markets with untapped profitable segments. Besides, as an innovative technology, AI facilitates the design of new products and services (Wamba-Taguimdje et al., 2020). In this regard, there are many possibilities for creating products and services that embed AI-based functionality. For example, organizations can use AI to introduce new services around conventional products in order to enhance customer service with applications such as recommender systems, chatbots, or intelligent agents (Alsheibani et al., 2020). In sequence, the introduction of new products and services can prompt business model innovation. Furthermore, studies have shown that AI-based recommendations can aid product developers in designing new products, particularly when it comes with design aid which can enhance creativity (Mikalef & Gupta, 2021). Business model innovation can, in turn, help companies preserve their market position (Lee et al., 2019).

Enhance the quality of products and services AI can also enhance the quality of already existing products and services. Davenport and Ronanki (2018) found in a survey that more than half of the executives said that their primary goal of adopting AI was to make existing products better. There are numerous ways AI can enhance the quality of products and services. For example, Netflix uses AI to enhance the video quality of their streaming services. Spotify uses AI to enhance their product in several ways, such as providing personalized song recommendations. Personalization of products and services are becoming more and more popular these days. By using AI to analyze customer data, organizations can provide a personalized experience to each customer, possibly causing the customers to perceive the product or service to have enhanced quality. Spotify, Netflix and Amazon are some of the many companies using AI to personalize the experience for customers.

# 4.3.2 Second-Order Impacts

The second-order impacts of AI are related to the firm-level effects of AI use in operations. These effects can be divided into four categories: operational performance, financial or accounting performance, market-based performance, and sustainability performance.

Operational Performance AI can have an impact on the operational performance in several ways, such as through the

Financial Performance Over the last few years, AI has been gradually embedded in key organizational activities, prompting business growth is various sectors (Eriksson et al., 2020). Organizations that have implemented AI solutions have realized financial and accounting performance gains, such as increased revenue and cost reduction (Alsheiabni et al., 2018; Davenport & Ronanki, 2018). In a recent empirical study, Mikalef and Gupta (2021a) find that companies that have developed a structured approach to AI adoption and use, and developed an organizational capability around the novel technologies have realized performance gains. Their analysis points out to the fact that an AI capability has a positive effect on important financial and accounting performance indicators such as growth in overall financial performance. Nevertheless, to date there are few studies examining other measures of financial performance, such as return-on-investments, profitability, and gross profit margin after the introduction of AI.

Market-Based Performance Marketing effectiveness Organizations using AI for marketing purposes are suggested to experience several benefits. A typical way in which AI can lead to marketing performance is to segment customers based on their needs to target the segments with different and customized marketing strategies. AI can enhance customer segmentation by processing and learning from existing customer data, enabling organizations to learn about their customers’ preferences and lifestyle in a whole new way. This capability enables a more precise segmentation because organizations can classify customers on a finer level (Mishra & Pani, 2020). Consequently, organizations can target their marketing better (Afiouni, 2019), and it opens for the possibility of delivering one-to-one marketing by personalizing the experience (Mishra & Pani, 2020). Thus, AI enhances the marketing effectiveness and accuracy by targeting the right customers with the right marketing strategy. Also, as customer behavior changes, segmentation suggestions from the AI system are regenerated so that organizations can effectively adapt their marketing strategy (Afiouni, 2019).

Customer satisfaction Customer satisfaction is related to how satisfied a customer is with a company’s offerings, and it directly affects the loyalty and retention of customers. By using AI, companies can learn more about their customers’ behaviors and, in turn, use this enhanced understanding to proactively prevent any negative experiences (Riikkinen et al., 2018). In doing so, companies can provide offerings that reduce customer attrition, such as providing personalized services or offers. For example, by using AI in the interaction with customers, customer satisfaction can increase because customers get better informed and find better-customized solutions guided by AI (Schmidt et al., 2020). However, the use of AI can also lead to customer dissatisfaction. For example, customers interacting with AI-powered chatbots can find the experience frustrating and ineffective (Castillo et al., 2020). Hence, it is important in the design of AI systems that have a direct interaction with customers, that their experiences and perceptions are considered.

Sustainability Performance AI’s disruptive potential can drive business model innovation toward sustainability (Toniolo et al., 2020). Sustainable business models describe how organizations create, deliver, and capture value in a way that contributes to the sustainable development of the company and society (Toniolo et al., 2020). In other words, companies should conduct their business while at the same time focusing on environmental and social matters. AI has the potential to impact individuals and society in a disruptive and long-term manner (Alsheibani et al., 2020).

Environmental AI can affect environmental sustainability, such as by minimizing energy costs, reducing energy consumption and, in turn, reducing negative environmental impacts (Borges et al., 2020; Toniolo et al., 2020). Also, the use of AI tools can help organizations to reduce pollution and waste (Toniolo et al., 2020). A growing body of research is also examining the impact that AI applications have in supporting circular economy strategies, by enabling organizations to pursue strategies that promote recycling, reduction of emissions, and re-use of materials (Rajput & Singh, 2019).

Social By considering social responsibility, organizations can improve their reputation and increase their market share, which in turn can affect their competitive advantage (Toniolo et al., 2020). The adoption of AI opens up many new challenges for organizations in fulfilling their social responsibilities. Examples are challenges regarding privacy and discrimination. Recall that the fundamental enabler of AI systems is data. Organizations need to ensure the privacy of data on their customers and employees (Lee et al., 2019). Also, they must ensure that the the use of AI does not result in discriminatory actions or results. As AI is based on data, the results can be biased or discriminatory if the underlying data is. AI systems understand neither the inputs they process nor their outputs (Keding, 2020). They learn by interpreting patterns in previous data to predict the future. Thus, the results may reflect suspicious patterns, such as sexism and racism, found in the underlying data (Keding, 2020). For example, in recruitment processes: if the AI system explores the existing recruitment process, and this process lacks diversity (e.g. gender and ethnicity), then the results of the system will continue to embrace this underlying discrimination (Afiouni, 2019). On the other side, as AI systems are objective, they can reduce human bias in processes, such as recruitment and customer segmentation (Afiouni, 2019; Toniolo et al., 2020). Also, employees’ safety and working conditions can be enhanced with the introduction of AI. Using AI robots in manufacturing where hazards may be present, the safety conditions for employees can increase (Toniolo et al., 2020). Besides, automating repetitive routine tasks causes employees to use their capabilities and competencies elsewhere, possibly leading to more meaningful and creative jobs (Toniolo et al., 2020). This change can affect how employees perceive their working environment.

Unintended Consequences and Negative Impacts While research predominantly focuses on positive effects of AI deployment and use, several recent examples showcase that in the absence of appropriate AI governance practices, negative and unintended consequences can occur. One of the most prominent examples is the failure of organizations to identify and eliminate bias in the data or AI algorithms, which can result in discrimination or unfavorable outcomes to particular ethnic groups, genders, or population clusters. For instance, there have been several news reports on biased AI outcomes concerning gender (Dastin, 2018; Vigdor, 2019) and racial discrimination (Zuiderveen Borgesius, 2020). Such outcomes have negative effects on the image of the companies they involve, and in some cases have resulted to financial losses and significant fines (Engler, 2021). Such outcomes increase the pressure towards organizations that use AI to apply practices to reduce bias in data and algorithms throughout all stages of deployment. In fact, due to the surge of several noteworthy cases of bias and discrimination as a result of AI outcomes, governmental agencies such as the European Commission, are now proposing concrete regulations that will dictate how AI applications are developed and used.

Negative impacts due to AI use, however, are not restricted to biased outcomes, but include a number of other aspects such as black-box algorithms, lack of transparency and accountability, security concerns, as well as harm to society and the environment (Yudkowsky, 2008). An example of the effects such unintended consequences have had includes the growing requirement for organizations to introduce explainability in how AI algorithms reach certain outcomes (Arrieta et al., 2020). In addition, this move has sparked a general need to provide more transparency of the entire process from data collection to outcome generation (LoyolaGonzalez, 2019). A lack of explainability practices and low transparency hampers individuals trust in AI systems and leads to non-use (Samek & Müller, 2019). In addition, cases of AI use for customer and citizen interaction (e.g. chatbots) that have not taken into account human-centric principles have resulted in frustration and complaints from users, hampering the corporate image (Marcondes et al., 2019).

# 4.4 Theories and Frameworks in Empirical Studies

In this section we examine the theoretical perspectives that were used in the sample of articles we analyzed. While not all articles built their investigations on a theoretical grounding, a surprisingly high number of papers did. In the table presented below (Table 6), we document those that have been employed, describing how they have been applied in the study of AI, and their overall scope of application. Despite still being at a nascent stage, the papers looking at different facets of AI in organizations demonstrate considerable variety in the use of theoretical perspectives. Specifically, we see that many articles use firm-level theories in studying aspects that contribute to the effective adoption and deployment of AI applications in the organizational setting, such as the TOE framework and the Resource-Based View (RBV) of the firm. As research in this domain is still at an early stage, it expected that the majority of work will be revolved around understanding how to deploy these novel technologies in operations, and complementary organizational resources need to be deployed to support these.

However, we find that several articles also examine the processes of AI development, and the knowledge-intensive practices that surround AI maturation. As AI applications involve a lengthy process of development and refinement, by tweaking algorithms, data, and analysis methods, they create an opportunity for organizations to learn by doing. Several studies have applied relative theoretical perspectives, such as organizational learning theory and theory of artificial knowledge creation to elucidate this process. In addition, as AI applications are heavily data-dependent, other articles such as that of Gregory et al. (2020) have worked on developing new theoretical perspectives such as the network effect, in an attempt to understand how AI platforms become more useful and of value as users and data increase. Finally, some studies have focused on the individual as the unit of analysis, with theoretical perspectives such as dual process theory looking into the interactions of human and AI for optimizing decision-making, and value co-destruction building on a darkside angle of how negative interactions reduce use of AI systems.

# 5 Research Agenda

From the synthesis in Section 4, several research gaps are identified in relation to the study of AI use in organizations. Through challenging assumptions and identifying areas where there is a significant lack of knowledge, this section aims to provide a framework for guiding future research. The goal is not to present an exhaustive list of potential research directions, but rather, to highlight some important gaps in our understanding of how AI is shaping the way organizations are conducting business and competing. We therefore define five research themes, with each presenting a number of research directions (D) that can help expand our knowledge. The research framework is presented in Fig. 3, with the themes being represented in the enumerated circles.

# 5.1 Theme 1: AI Adoption and Diffusion

D1.1 Difficulties in the Process of Adopting and Deploying AI Although the proposed business value that organizations can derive from AI is argued to be significant for all kind of business operations, there is still a very small percentage of companies that to date have adopted and deployed AI applications beyond pilot projects (Anon, 2020). Companies face a number of challenges when it comes to adopt and deploy AI (Alsheibani et al., 2018). According to Alsheibani et al.

<html><body><table><tr><td>Contingency theory</td><td>Contingency theory posits that there is no one best way to adopt and implement AI, but rather,different contingencies of the internal and external environment need to</td><td>Organizational adoption and use of AI</td><td>Eriksson et al. (2020)</td></tr><tr><td>Dual process theory</td><td>be considered when doing so. Understanding how to develop accurate AI-based predictions in uncertain situations requires an examination of the mental pro- cesses that underly the cognitive</td><td>AI use for decision-making</td><td>Dellermann et al. (2017)</td></tr><tr><td>Resource-Based View (RBV)</td><td>decision-making process. Defines the different types of complementary resources that organizations should foster in order to be able to realize business value</td><td>AI-business value</td><td>Mikalef and Gupta (2021a); Wamba-Taguimdj</td></tr><tr><td>TOE framework</td><td>from their AI investments. The process by which a firm adopts and implements AI is influenced by the technological context, the organizational</td><td>Organizational AI adoption</td><td>Demlehner and Laumer (2020)</td></tr><tr><td>Value co-destruction</td><td>context, and the environmental context AI value depends on complex interactions between actors and the functions provided by AI applications</td><td>AI individual use</td><td>Castillo et al. (2020)</td></tr><tr><td>Organizational Learming Theory</td><td>There exists a dynamic interplay between learning that occurs in AI algorithms,and learning that occurs within the organization.</td><td>Organizational learning through AI projectsAfiouni (2019)</td><td></td></tr><tr><td>Theory of Artificial Knowledge Creation</td><td>Explains how tacit and explicit knowledge held by individuals and organizations can be simultaneously enlarged and enriched through the recursive and reflexive amplification of tacit and explicit</td><td>Knowledge creation in AI projects</td><td>Quinio et al. (2017)</td></tr><tr><td>Network effect</td><td>knowledge enabled by AI. A platform exhibits data network effects iftheAI platform value more that the platform learns from the data it collects on users,the more valuable the platform becomes to each user</td><td></td><td>Gregory et al. (2020)</td></tr></table></body></html>

![](images/2bbce4803e9245ed61b808b1a78abb2e8c67acad60649d6e41222feb3d543073.jpg)  
Fig. 3 AI and business value research framework

(2018) technological readiness, organizational readiness, and environmental readiness (environmental conditions such as government regulations) are important aspects that influence the adoption of AI. Other difficulties can include the costs in infrastructure, hiring capable employees and relying on external partners. Hence, the different dynamics that have a role in allowing organizations to adopt AI and in turn develop an AI capability require a deeper understanding. Due to the nature of AI that requires employees from different business units to work together to build AI applications, the socio-technical arrangements and the process through which AI applications are developed and deployed warrants further investigation (Holton & Boyd, 2019).

In addition, conflicts between shareholders and managers could have important consequences on the actual use of AI in operations. Specifically, the conflicting views where shareholders encourage automation for reducing costs (Dedrick et al., 2013), while managers promote augmentation may cause a paralysis in actual deployment (Shollo et al., 2020). Moreover, the use of AI might challenge cultural norms and act as a potential barrier for managers or even customers to accept AI technologies (Dwivedi et al., 2019). Hence, further enlightenment in these areas is needed as it is crucial identifying the difficulties and the cultural obstacles and knowing how to overcome them. Finally, the modes of human-AI symbiosis and the changes these induce in organizational structures require further investigation (Shrestha et al., 2019). AI is argued to lead to significant adjustments to how business and IT functions work, collaborate, and exchange knowledge, so finding optimal ways of doing so is critical for successful AI deployments.

D1.2 Responsible AI Governance While investing in technological infrastructure for AI may be an important part, organizations hoping to use AI in core operations must be able to govern the necessary resources and have thorough practices and mechanisms for orchestrating and following up on projects from ideation to completion (Papagiannidis et al., 2021). In addition, AI applications require several phases of maturation, and are subject to continuous improvement and development. A core requirement for most types of AI applications (e.g., in public sector) is taking into account ethical aspects and principles of responsible design. Hence, the concept of AI governance is inextricably associated with responsible and ethical principles being embedded throughout the process of design, deployment, and evaluation. Therefore, being able to break down the concept of AI governance and outline which key activities underpin the notion is an important research quest.

Past studies on IT governance have shown that having established such practices not only helps optimize output, but also enables organizations to achieve business and IT fit (Tallon & Pinsonneault, 2011). Nevertheless, AI poses an additional concern since the effects towards, as well as the interactions with humans shifts fundamentally. This poses a requirement to examine not only how AI applications are developed so that they are aligned with responsible principles (European Commission, 2019a), but also to anticipate and plan for their effects as the gradually become embedded in everyday activities. In their recent work, Amer-Yahia et al. (2020) outline what they refer to as “intellectual challenges”, which comprise of major themes organizations must consider when they plan to deploy AI applications that concern the changing nature of interaction between humans and technology. An important area of inquiry therefore concerns what responsible AI governance comprises of, as well as what are the effects of implementing such practices at different levels of analysis.

# 5.2 Theme 2. AI and Socio-organizational Change

D2.1 How Does AI Change Organizational Culture? Organizational culture has been consistently noted as being an important part of AI adoption and use (Mikalef & Gupta, 2021). Innovative cultures are in a better position to adopt AI. But can an innovative technology like AI lead to alteration to the organizational culture itself? This question has yet to be examined, particularly in relation to the ripple effects the adoption and use of AI may have on different aspects of organizational culture, like learning, collaboration, and communication patterns. In addition, an interesting point to explore is if the adoption of innovative technologies like AI affects the organization’s ability to innovate further. Does the introduction of AI change the mindset of the employees to being more open to innovations? An interest field of inquiry therefore concerns if and through what mechanisms innovation outcomes are achieved as part of AI deployments. With the introduction of new and disruptive digital technologies, many prominent cases of organizations have documented an increase of innovation output (Nambisan et al., 2017). Future research therefore needs to examine through what arrangements organizations are able to harness the possibilities of AI technologies in order to drive innovation.

Taking a contrarian view, the dark side effects of AI also warrant further investigation in the context of organizational culture. The introduction of AI and displacement or shifting of several conventional job roles is likely to lead to increased tensions, conflict, and feelings of distrust towards the technology itself and the units that promote its deployment (Huang et al., 2019). Therefore, a major challenge for practitioners is how to be able to manage the human factor internally when planning their AI implementations. Negative perceptions can result in rigidity in digital transformation and lead to inertia, thus significantly impacting organizational performance. There is, as a result, a need for future research to examine how IT managers can plan for and deploy AI applications to minimize potential friction and facilitate trust and acceptance of newly deployed solutions.

D2.2 What is the Role of AI-driven Automation in Decisionmaking? Automating processes through the use of AI is argued to reduce the workload of employees in certain activities and increase efficiency of process completion (Acemoglu & Restrepo, 2018). At the same time, AI is able to automate decision-making when provided with appropriate data and business rules (Duan et al., 2019). Delegating such authority to AI applications however raises the issue of how to prevent bias that AI models might have, and how to ensure that new decision-making structures are improved, rather than debased, with the introduction of AI (Cirillo et al., 2020). While a number of studies have opened up the discussion about what the optimal decision-making structures are and how organizations can ensure that the introduction of AI enhances them, there is still a lack of empirical studies examining the effects of such arrangements (Shrestha et al., 2019). Such studies require an understanding of the impacts from the individual level, up to the business and organizational level of analysis, in order to fully capture the nature and types of effects that blended human-AI arrangements have.

D2.3 How Does AI Change the Organizations Structure? The connection between AI adoption and organizational structure is one of a reciprocal nature. Organizational structure may affect the ability to adopt AI, and AI adoption may affect the organizational structure. Pumplun et al. (2019) found that a company’s organizational structure may affect its ability to adopt AI and propose that "Departments who keep relevant data to themselves, an overreliance on status quo as well as slow and bureaucratically shaped corporate structures will have a negative effect on the adoption of AI in companies". This proposition suggests that organizations structured in functional silos, will encounter more challenges when adopting AI. A reason for this can be that these structures do not facilitate a holistic approach to solve problems. On the contrary, agile organizational structures are more flexible and can respond quickly to change, thus supporting innovation. However, such arrangements have received little empirical attention to date. Therefore, future research needs to engage in the study of how organizational structures affect AI adoption. Nevertheless, such relationships are likely to have a dynamic and reciprocal nature. As identified during the systematic literature review, AI influences how human resources are used, possibly redesigning the organizational chart (Eriksson et al., 2020) (Wamba-Taguimdje et al., 2020). Previous roles and structures are likely to change, and new roles may emerge. Therefore a promising avenue for future research is to examine through longitudinal approaches how organizations transform in order to embrace AI technologies.

# 5.3 Theme 3. AI-driven Value Propositions

D3.1 How Does the Orientation of AI Impact Value Propositions? The potential use cases for AI technologies within the organizational sphere are manifold, and a plethora of value-adding applications have been suggested both for private and public organizations (Davenport & Ronanki, 2018). One broad categorization that can be made involves the distinction between the use of AI for internal- and external-oriented functions. Internal functions involve using AI for improving internal business processes, such as decision-making, or for streamlining internal business processes. On the other hand, external functions include using AI in products and services that are in direct contact with customers Some examples of the later include the use of AI to recommend songs of interest to listeners by Spotify. It is therefore expected that the value-adding possibilities of AI applications are very diverse in nature. To date, there are to the best of our knowledge no studies that differentiate on performance metrics depending on the use case of AI. Furthermore, such an area of inquiry also raises the question of what the appropriate metrics are in order to be able to capture effects of AI and how to benchmark different similar applications.

D3.2 What is the Role of Complexity in AI Application Inimitability and Value? While high complexity in AI applications may lead to black-box systems with limited transparency, high complexity can also result in difficult to imitate projects, leading to a longer period where firms can sustain an edge over their rivals (Wamba-Taguimdje et al., 2020). Nevertheless, the notion of complexity is compound, and involves aspects such as how many features are included in the model (Monostori, 2003), the diversity of data sources used, the interactions with other systems and processes, as well as the breadth and depth of activities they span. There are instances where large cooperation’s, such as Alibaba’s fraud risk management system (Chen et al., 2015), initiated high complexity projects that yielded significant returns. Nevertheless, some of these projects had little success and the value creation for the business was little if none. Hence, the correlation between the complexity of an AI system and the value creation for the business requires further exploration. Understanding when value creation is adding based on the complexity of the AI system could allow organizations to identify what aspects of their developed AI projects lead to a competitive advantage. As a result, a deeper understanding of how complexity adds or retracts value in the case of AI applications presents an interesting field of study, as well as developing deeper theorizing on the phenomenon of digital complexity (Benbya et al., 2020).

# 5.4 Theme 4. Competitive Value of AI

# D4.1 What are the Effects of AI on Financial Performance?

One of the key expectations from practitioners before adopting AI applications is that they can help improve financial performance indicators, such as revenue, growth, and help reduce costs (Alsheiabni et al., 2018; Eriksson et al., 2020). Nevertheless, there is a long chain of causal associations, and to date it is still not clear if and how AI can help organizations achieve financial performance gains. From our sample of articles there were none that studied the long-term financial consequences of AI adoption. Instead, the focus was on identifying short-term operational trends. Thus, it is important, particularly for small and medium-sized enterprises to elucidate the financial impacts that AI applications have in the long-term. As there are large financial investments tied to AI adoption, it is critical for firms that do not have large slack resources to know exactly the timeline in which AI applications start generating positive financial returns, and through what means and mechanisms. Prior studies have documented that there are large associated costs incurred by some organizations due to technology adoption, and which have resulted in significant financial losses (Chakravorty et al., 2016). It is therefore important to understand where the equilibrium lies between investing in the necessary AI resources, and the expected financial return.

D4.2 What are Appropriate Key Performance Indicators (KPIs) to Measure AI Success? Measuring the impact of an AI project is challenging as the results are often difficult to capture with purely quantitative measures. While businesses use KPIs to measure performance, AI applications are often gauged in their success in completely different measures. Some examples of AI success measures include calculating various metrics such as Mean Squared Error, Confusion Matrix and F1-score (Kawaguchi et al., 2017). These metrics are good for determining the overall performance of a model, but they say very little about the overall project success. More organizational-focused KPIs could prove more valuable, after AI applications have been deployed and used in practice (Ehret & Wirtz, 2017). Nevertheless, such measures are typically very context specific. In addition, the selected KPIs should be quantifiable and provide managers with insights about the impact of the AI project in the business (Glauner, 2020). There is as a result a large gap in understanding what appropriate measures are to identify AI outcomes, and help guide key stakeholders.

D4.3 How Can AI Drive Innovation? New products and services have been developed building on the functionality and affordance enabled by AI (Plastino & Purdy, 2018). Some prominent examples include Netflix’s recommendation systems, Amazon’s chatbot Alexa, and Tesla self-driving cars. Although AI is the technological innovation behind these services and products, there is little understanding regarding the sociotechnical dynamics that lead to innovation to be generated. While undoubtedly the novel technologies that support AI have an important impact on the creation of such innovation output, the role of managers and knowledge workers, as well as their interactions needs to be understood in more detail. As new digital solutions are now one of the main components of innovations, it is imperative to understand the nexus of associations that surrounds technology-driven innovation. To date, research on the business value of AI has not built sufficiently on the growing body of knowledge on digital innovation (Nambisan et al., 2020). Thus, there is a need to understand the phenomenon of AI and its role in driving innovation in a more structured and theory-driven manner, that can allow for more nuanced understanding of how such outcomes are achieved.

# 5.5 Theme 5. AI and the Extended Organization

D5.1 Extended Organizational Boundaries and Partnerships All businesses, despite their size and industry must interact with the external environment in order to remain competitive and evolve (Yang & Meyer, 2019). A sought-after option by many such organizations is engaging in different forms of organizational relationships, such as mergers, acquisitions, joint ventures and alliances. Yet, when it comes to AI applications literature largely sees the development of AI as an activity that happens in the focal organization. As organizations typically have complementary key datasets, or interlinked organizational processes, it is important to examine how these relationships dictate the types of AI applications that are developed, as well as how they prompt organizations to engage in different forms of organizational engagements. Large corporations have access to AI resources that are unavailable for the majority of the businesses, especially for small and medium-sized enterprises (Garbuio et al., 2011). Despite the managers' efforts for pioneering AI initiatives, it is not always possible to achieve goals due to limitations in key resources (Pellikka & Ali-Vehmas, 2016). A possible model to mitigate such limitations could be to engage in such strategic alliances. Doing so enables the organizations to have access to resources which they would not be able to acquire by themselves in other circumstance, while at the same time, both companies are able to increase their business value and benefit from each other's capabilities. Nevertheless, research regarding governance schemes for effectively cooperating under such AI-specific partnerships is still at an early stage in research. Building on this avenue helps understand that dynamics and conflicts of interest in such collaborative arrangements, as well as optimal ways of organizing. Furthermore, a prominent area of study is how organizations develop the necessary IT infrastructure to facilitate such interorganizational collaboration around AI.

D5.2 What is the Role of AI in Shaping the Reputation of the Organization? Maintaining D5.2 What is the role of AI in shaping the reputation of the organization?a good reputation with customers and partners is essential for organizations. It can affect several business areas, such as market value, ability to attract more skilled employees, and customers’ loyalty (Eccles et al., 2007). An organization’s reputation is highly linked with the ability of customers and stakeholders to trust the organization, and in turn has significant effects on overall financial performance. Yet, the introduction of AI technologies can influence the level of trust among critical external entities, such as customers and business partners. While AI technologies may have many of the same capabilities as humans, in cases where there is a lack of transparency on where and how AI is used, issues of distrust may arise. Some early studies have shown that in order for humans to garner feelings of trust towards AI outcomes, they need to understand how such technologies work, and have clearly defined indications of safety and reliability (Marcus & Davis, 2019). Thus, organizations adopting AI must be aware of the role of trust, how to build trust, and in turn, how trust influences their reputation and interaction with external stakeholders. Thus, a promising area for further research is to understand how the introduction of AI affects the trust people have in the organizations and, in turn, how it affects the organization’s reputation. Such research can examine the technical features of AI, how communications patters influence trustformation, as well as if there are any cultural differences among individuals in how they perceive AI applications (Felzmann et al., 2019).

# 5.6 Cross-cutting Challenges

The themes presented above that form our proposed research agenda, and the corresponding directions described within these themes, also raise several important concerns regarding the extended information value chains of organizations and the related activities within these (Abbasi et al., 2016; Koutsoukis & Mitra, 2003). In Table 7, we present some of the core challenges within the information value chain, and their relationship to our directions presented above. Specifically, we follow the distinction regarding the sequence of activities within the information value chain that differentiate between data, information, knowledge, decisions, and actions.

The table indicates that there are several cross-cutting challenges among the future directions which we defined. For example, when looking at the data artefact, issues regarding how data infrastructures are designed and deployed, as well as how they need to be adapted to the socio-technical context present a challenge that span several research directions within the first theme. Further challenges such as that of integrating data from a variety of sources, as well ensuring high quality input to AI algorithms, present serious obstacles for contemporary organizations (Ransbotham et al., 2018).

Table 7 Information value chain challenges and research directions   

<html><body><table><tr><td>Information Value Chain</td><td>Challenge</td><td>Direction(s)</td></tr><tr><td rowspan="3">Data</td><td>Data infrastructures</td><td>D1.1, D1.2</td></tr><tr><td>Data integration</td><td>D1.1, D1.2, D3.2</td></tr><tr><td>Data quality</td><td>D1.2</td></tr><tr><td rowspan="3">Information</td><td>Information representation</td><td>D1.2</td></tr><tr><td>Information access</td><td>D1.2,D2.3,D5.1</td></tr><tr><td>Information processing</td><td>D1.1, D2.2, D4.3</td></tr><tr><td rowspan="2">Knowledge</td><td>Innovation management</td><td>D3.1, D4.3</td></tr><tr><td>Business intelligence</td><td>D2.2, D4.3</td></tr><tr><td rowspan="2">Decisions</td><td>Decision structures</td><td>D2.1,D2.2,D2.3,D4.3</td></tr><tr><td>Accountability</td><td>D1.2,</td></tr><tr><td rowspan="2">Actions</td><td>Value measurement</td><td>D4.1, D4.2</td></tr><tr><td>Competitive advantage</td><td>D4.1,D5.2</td></tr></table></body></html>

Similarly, defining the procedures that surround information access, processing, and representation constitute tough obstacles for private and public organizations, as they concern technical facets of AI, as well as organizational and procedural aspects that span the entire organization (Dwivedi et al., 2021; Schaefer et al., 2021). As AI applications span multiple units within organizations, being able to deal with the technical requirements, as well as the necessary organizational changes that are needed to generate business value, is a challenge that organizations of all size-classes with be required to face (Mikalef & Gupta, 2021). The same applies also concerning how knowledge that is derived from AI applications or infused into such applications, is managed within organizations. Being able to harness the knowledge that AI applications can deliver is critical in generating business value out of AI applications, so it is important that organizations are structured appropriately in order to leverage such technologies in ways that contribute to value generation (Collins et al., 2021).

A final consideration regarding the cross-cutting themes of AI in organizations has to do with how decision-structures are shifted, as well as what competitive actions such technologies enable. There has been an ongoing debate about the different configurations of decision-making structures that utilize the strengths of human and AI agents, as well as their potential to generate business value (Shrestha et al., 2019). Adding to this, to be able to evaluate the value of AI applications, it is also important to have appropriate indicators of the value they deliver, as well as associate their use with the ability to attain a competitive advantage (Dwivedi et al., 2021).

# 6 Conclusion

AI is increasingly becoming important for organizations to create business value and achieve a competitive advantage. However, many AI initiatives fail even though time, effort, and resources have been invested. There is a lack of a coherent understanding of how AI technologies can create business value and what type of business value can be expected.

In this paper, we present a narrative review to identify how organizations can deploy AI and what value-generating mechanisms such AI uses have. The result of this analysis consists of three parts. First, several enablers and inhibitors of AI use are identified. These antecedents of AI adoption consist of technological, organizational, and environmental resources and conditions. Second, different use cases for AI are distinguished. Organizations can use AI technologies to automate tasks or augment humans, either for internal or external purposes. Internal purposes mean using AI to improve internal business processes, where the customer is not in direct contact with the AI-solution. Furthermore, external purposes mean using AI in products and services that are in direct contact with the customers. Lastly, the impacts of AI are discussed, specifically how organizations change and how this leads to competitive performance. Several implications of AI at both the process- and firm-level are identified.

The findings in this article have several implications for how to manage AI in organizations. By considering the enablers and inhibitors found, organizations can better assess their ability to adopt AI successfully and know which changes to make. Moreover, by knowing how AI can be used, organizations can make better decisions about where in their value chain to implement AI solutions. Lastly, knowing the possible effects of AI adoption can better prepare organizations to introduce AI in their line of work. We conclude this study by presenting a research agenda that identifies areas that need to be addressed by future research to understand AI technologies’ value-generating mechanisms in the broader organizational environment. While this study may not follow an exhaustive approach in documenting and presenting the themes in the paper, we attempt to present themes through the ITbusiness value perspective. In addition, although a systematic approach was used in searching for and analyzing the paper contents, we did not follow a specific method for documenting and reporting results, such as PRISMA (Moher et al., 2015).

# Appendix

Table 8 Keywords used in selection of papers   

<html><body><table><tr><td>Thematic Category</td><td>Keywords</td></tr><tr><td>AI technologies</td><td>Artificial intelligence,cognitive technology,robotic automation,cognitive insight,process automation, machine learning,deep learning,cognitive automation, neural network,supervised learning,unsupervised learning,natural language processng,computer vision, machine vision, expert systems, cognitive application, image recognition,reinforcement learning,deep mind technologies,adaptive algorithms,recurrent neural networks,machine perception, machine intelligence, heuristic search techniques,decision tree,data mining, convolutional neural network, cluster analysis, classification, chatbots,autonomic computing,semantic analysis, image recognition,simulation intelligence, challenges ofAI,integrateAI,cost ofAI,deploymntof AI,AI and big data, influence of AI,AI transformation, Bayesian learning system</td></tr><tr><td>Organizational</td><td>Business value,organizational challenges,organizational opportunities,adoption,business benefits,business process redesign,organizational change, firm performance,organizational performance,competitive advantage,process innovation, business transformation, business process management, digital transformation, business strategy,business gains,business performance, cognitive engagement, business opportunities, transformation process,business activities,data-driven decisions,competitive performance,business efficiency, reduce business costs,business management, business decision,business challenges,commercial value,busi- ness value proposition, business growth, business success, customer value, customer fragmentation, cus- tomer service,corporate value,leadership,swot analysis, obstacles,deployment,assimilation</td></tr></table></body></html>

Funding Open access funding provided by NTNU Norwegian University of Science and Technology (incl St. Olavs Hospital - Trondheim University Hospital).

Open Access This article is licensed under a Creative Commons Attribution 4.0 International License, which permits use, sharing, adaptation, distribution and reproduction in any medium or format, as long as you give appropriate credit to the original author(s) and the source, provide a link to the Creative Commons licence, and indicate if changes were made. The images or other third party material in this article are included in the article's Creative Commons licence, unless indicated otherwise in a credit line to the material. If material is not included in the article's Creative Commons licence and your intended use is not permitted by statutory regulation or exceeds the permitted use, you will need to obtain permission directly from the copyright holder. To view a copy of this licence, visit http://creativecommons.org/licenses/by/4.0/.

# References

Abbasi, A., Sarker, S., & Chiang, R. H. (2016). Big data research in information systems: toward an inclusive research agenda. Journal of the Association for Information Systems, 17(2)   
Acemoglu, D., & Restrepo, P. (2018) The race between man and machine: Implications of technology for growth, factor shares, and employment. American Economic Review, 108(6), 1488–1542   
Afiouni, R. (2019). Organizational learning in the rise of machine learning. International Conference on Information Systems, Munich, Germany   
Alsheibani, S., Cheung, Y., & Messom, C. (2018). Artificial intelligence adoption: AI-readiness at firm-level. Artificial Intelligence, 6, 26– 2018   
Alsheibani, S., Cheung, Y., Messom, C., & Alhosni, M. (2020). Winning AI strategy: six-steps to create value from artificial intelligence. Americas Conference on Information Systems, Online   
AlSheibani, S., Messom, C., & Cheung, Y. (2020). Re-thinking the competitive landscape of artificial intelligence. Proceedings of the 53rd Hawaii international conference on system sciences   
Alsheibani, S., Messom, D., Cheung, Y., & Alhosni, M. (2020). Reimagining the strategic management of artificial intelligence: Five recommendations for business leaders. Americas Conference on Information Systems, Online   
Amer-Yahia, S., Basu Roy, S., Chen, L., Morishima, A., Abello Monedero, J., Bourhis, P., & Demartini, G. (2020). Making AI machines work for humans in FoW. ACM SIGMOD Record, 49(2), 30–35   
Anon. (2020). AI is essential to India's future of work, study finds. M2 Presswire   
Arrieta, A. B., Díaz-Rodríguez, N., Del Ser, J., Bennetot, A., Tabik, S., Barbado, A., & Benjamins, R. (2020). Explainable Artificial Intelligence (XAI): Concepts, taxonomies, opportunities and challenges toward responsible AI. Information Fusion, 58, 82–115   
Baby, C. J., Khan, F. A., & Swathi, J. (2017). Home automation using IoT and a chatbot using natural language processing. 2017 Innovations in Power and Advanced Computing Technologies (iPACT)   
Baier, L., Jöhren, F., & Seebacher, S. (2019b). Challenges in the deployment and operation of machine learning in practice. In Proceedings of the 27th European Conference on Information Systems (ECIS), Stockholm, Sweden   
Balasundaram, S., & Venkatagiri, S. (2020). A structured approach to implementing Robotic Process Automation in HR. Journal of Physics: Conference Series , 1427(1), 012008. IOP Publishing.   
Bauer, W., & Vocke, C. (2019). Work in the age of artificial intelligence– challenges and potentials for the design of new forms of humanmachine interaction. International Conference on Applied Human Factors and Ergonomics   
Benbya, H., Nan, N., Tanriverdi, H., & Yoo, Y. (2020). Complexity and information systems research in the emerging digital world. MIS Quarterly 44(1), 1–17   
Beyer, M., & Laney, D. (2012). The importance of “Big Data”: a definition. Gartner   
Borges, A. F., Laurindo, F. J., Spínola, M. M., Gonçalves, R. F., & Mattos, C. A. (2020). The strategic use of artificial intelligence in the digital era: Systematic literature review and future research directions. International Journal of Information Management, 102225   
Bytniewski, A., Matouk, K., Chojnacka-Komorowska, A., Hernes, M., Zawadzki, A., & Kozina, A. (2020). The functionalities of cognitive technology in management control system. Asian Conference on Intelligent Information and Database Systems   
Castillo, D., Canhoto, A. I., & Said, E. (2020). The dark side of AIpowered service interactions: exploring the process of codestruction from the customer perspective. The Service Industries Journal, 1–26   
Chakravorty, S. S., Dulaney, R. E., & Franza, R. M. (2016). ERP implementation failures: a case study and analysis. International Journal of Business Information Systems, 21(4), 462–476   
Chen, J., Tao, Y., Wang, H., & Chen, T. (2015). Big data based fraud risk management at Alibaba. The Journal of Finance and Data Science 1(1), 1–10   
Cirillo, D., Catuara-Solarz, S., Morey, C., Guney, E., Subirats, L., Mellino, S., & Chadha, A. S. (2020). Sex and gender differences and biases in artificial intelligence for biomedicine and healthcare. NPJ Digital Medicine, 3(1), 1–11   
Collins, C., Dennehy, D., Conboy, K., & Mikalef, P. (2021). Artificial intelligence in information systems research: A systematic literature review and research agenda. International Journal of Information Management, 60, 102383   
Coombs, C., Hislop, D., Taneva, S. K., & Barnard, S. (2020). The strategic impacts of Intelligent Automation for knowledge and service work: An interdisciplinary review. The Journal of Strategic Information Systems, 29(4), 101600   
Damper, R. I., Marchand, Y., Adamson, M. J., & Gustafson, K. (1999). Evaluating the pronunciation component of text-to-speech systems for English: A performance comparison of different approaches. Computer Speech & Language, 13(2), 155–176   
Dastin, J. (2018). Amazon scraps secret AI recruiting tool that showed bias against women. Reuters. Retrieved 15/06 from https://www. reuters.com/article/us-amazon-com-jobs-automation-insight/ amazon-scraps-secret-ai-recruiting-tool-that-showed-bias-againstwomen-idUSKCN1MK08G   
Davenport, T. H., & Ronanki, R. (2018). Artificial intelligence for the real world. Harvard Business Review, 96(1), 108–116   
Dedrick, J., Kraemer, K. L., & Shih, E. (2013) Information technology and productivity in developed and developing countries. Journal of Management Information Systems, 30(1), 97–122   
Dellermann, D., Lipusch, N., Ebel, P., Popp, K. M., & Leimeister, J. M. (2017). Finding the unicorn: Predicting early stage startup success through a hybrid intelligence method. International Conference on Information Systems (ICIS), Seoul, South Korea   
Demlehner, Q., & Laumer, S. (2020). Shall we use it or not? Explaining the adoption of artificial intelligence for car manufacturing purposes In Proceedings of the 28th European Conference on Information Systems (ECIS), Online   
Duan, Y., Edwards, J. S., & Dwivedi, Y. K. (2019). Artificial intelligence for decision making in the era of Big Data–evolution, challenges and research agenda. International Journal of Information Management, 48, 63–71   
Dwivedi, Y. K., Hughes, L., Ismagilova, E., Aarts, G., Coombs, C., Crick, T. … Eirug, A. (2021). Artificial Intelligence (AI): Multidisciplinary perspectives on emerging challenges, opportunities, and agenda for research, practice and policy. International Journal of Information Management, 101994   
Eccles, R. G., Newquist, S. C., & Schatz, R. (2007) Reputation and its risks. Harvard Business Review, 85(2):104   
Ehret, M., & Wirtz, J. (2017). Unlocking value from machines: business models and the industrial internet of things. Journal of Marketing Management, 33(1–2), 111–130   
Engler, A. (2021). Auditing employment algorithms for discrimination. Retrieved 15/06 from https://www.brookings.edu/research/auditingemployment-algorithms-for-discrimination/   
Eriksson, T., Bigi, A., & Bonera, M. (2020). Think with me, or think for me? On the future role of artificial intelligence in marketing strategy formulation. The TQM Journal, 32(4), 795–814.   
European Commission. (2019a). Ethics guidelines for trustworthy AI. https://ec.europa.eu/newsroom/dae/document.cfm?doc_i $\scriptstyle 1 = 6 0 4 1 9$ . Accessed 23 Apr 2021   
European Commission. (2019b). Proposal for a Regulation laying down harmonised rules on artificial intelligence. Retrieved 15/06 from https://digital-strategy.ec.europa.eu/en/library/proposal-regulationlaying-down-harmonised-rules-artificial-intelligence   
Felzmann, H., Villaronga, E. F., Lutz, C., Tamò-Larrieux, A. (2019). Transparency you can trust: Transparency requirements for artificial intelligence between legal norms and contextual concerns. Big Data & Society ,6(1), 2053951719860542   
Finch, G., Goehring, B., & Marshall, A. (2017). The enticing promise of cognitive computing: high-value functional efficiencies and innovative enterprise capabilities. Strategy & Leadership, 45(6), 26–33   
Fountaine, T., McCarthy, B., & Saleh, T. (2019). Building the AIpowered organization. Harvard Business Review, 97(4), 62–73   
Galloway, C., & Swiatek, L. (2018). Public relations and artificial intelligence: It’s not (just) about robots. Public Relations Review, 44(5), 734–740   
Garbuio, M., King, A. W., & Lovallo, D. (2011). Looking inside: Psychological influences on structuring a firm’s portfolio of resources. Journal of Management, 37(5), 1444–1463   
Geva, M., Goldberg, Y., & Berant, J. (2019). Are we modeling the task or the annotator? an investigation of annotator bias in natural language understanding datasets. arXiv preprint arXiv:1908.07898   
Ghadage, Y. H., & Shelke, S. D. (2016). Speech to text conversion for multilingual languages. 2016 International Conference on Communication and Signal Processing (ICCSP)   
Glauner, P. (2020). Unlocking the power of artificial intelligence for your business. In: Innovative Technologies for Market Leadership. Future of Business and Finance (pp 45–59). Springer International Publishing   
Gregory, R. W., Henfridsson, O., Kaganer, E., & Kyriakou, H. (2020). The role of artificial intelligence and data network effects for creating user value. Academy of Management Review(ja)   
Higgins, J. P. (2008). Cochrane handbook for systematic reviews of interventions version 5.0. 1. The Cochrane Collaboration. https:// www.cochrane-handbook.org   
Holton, R., & Boyd, R. (2019). Where are the people? What are they doing? Why are they doing it? (Mindell) Situating artificial intelligence within a socio-technical framework. Journal of Sociology, 57(2), 179–195.   
Huang, M. H., Rust, R., & Maksimovic, V. (2019). The feeling economy: Managing in the next generation of artificial intelligence (AI). California Management Review, 61(4), 43–65   
Jarrahi, M. H. (2018). Artificial intelligence and the future of work: human-AI symbiosis in organizational decision making. Business Horizons, 61(4), 577–586   
Jelonek, D., Mesjasz-Lech, A., Stępniak, C., Turek, T., & Ziora, L. (2019). The artificial intelligence application in the management of contemporary organization: Theoretical assumptions, current practices and research review. Future of Information and Communication Conference   
Kawaguchi, K., Kaelbling, L. P., & Bengio, Y. (2017). Generalization in deep learning. arXiv preprint arXiv:1710.05468   
Keding, C. (2020). Understanding the interplay of artificial intelligence and strategic management: four decades of research in review. Management Review Quarterly, 71(1), 91–134.   
Kirchmer, M., & Franz, P. (2019). Value-Driven Robotic Process Automation (RPA). International Symposium on Business Modeling and Software Design   
Kitchenham, B. (2004). Procedures for performing systematic reviews. Keele University, Issue   
Kolbjørnsrud, V., Amico, R., & Thomas, R. J. (2017). Partnering with AI: how organizations can win over skeptical managers. Strategy & Leadership, 45(1), 37–43   
Koutsoukis, N.S., & Mitra, G. (2003). Decision modelling and information systems: The information value chain, vol 26. Springer Science & Business Media   
LeCun, Y., Bengio, Y., & Hinton, G. (2015). Deep learning. Mature, 521(7553), 436–444   
Lee, J., Suh, T., Roy, D., & Baucus, M. (2019). Emerging technology and business model innovation: the case of artificial intelligence. Journal of Open Innovation: Technology, Market, and Complexity, 5(3), 44   
Lichtenthaler, U. (2019). An intelligence-based view of firm performance: profiting from artificial intelligence. Journal of Innovation Management, 7(1), 7–20   
Loyola-Gonzalez, O. (2019). Black-box vs. white-box: Understanding their advantages and weaknesses from a practical point of view. IEEE Access, 7, 154096–154113   
Makarius, E. E., Mukherjee, D., Fox, J. D., & Fox, A. K. (2020). Rising with the machines: A sociotechnical framework for bringing artificial intelligence into the organization. Journal of Business Research, 120, 262–273   
Marcondes, F. S., Almeida, J. J., & Novais, P. (2019). A short survey on chatbot technology: failure in raising the state of the art. International Symposium on Distributed Computing and Artificial Intelligence   
Marcus, G., & Davis, E. (2019). Rebooting AI: Building artificial intelligence we can trust Vintage   
Matei, A. M., & Iftene, A. (2019). Smart Home Automation through Voice Interaction RoCHI   
Mikalef, P , & Gupta, M. (2021). Artificial Intelligence Capability: Conceptualization, measurement calibration, and empirical study on its impact on organizational creativity and firm performance. Information & Management, Online. https://doi.org/10.1016/j.im. 2021.103434   
Mikalef, P., Pappas, I. O., Krogstie, J., & Giannakos, M. (2018). Big data analytics capabilities: a systematic literature review and research agenda. Information Systems and e-Business Management, 16(3), 547–578   
Mishra, A. N., & Pani, A. K. (2020). Business value appropriation roadmap for artificial intelligence. VINE Journal of Information and Knowledge Management Systems, 51(3), 353–368   
Moher, D., Shamseer, L., Clarke, M., Ghersi, D., Liberati, A., Petticrew, M., & Stewart, L. A. (2015). Preferred reporting items for systematic review and meta-analysis protocols (PRISMA-P) 2015 statement. Systematic Reviews, 4(1), 1–9   
Monostori, L. (2003). AI and machine learning techniques for managing complexity, changes and uncertainties in manufacturing. Engineering Applications of Artificial Intelligence, 16(4), 277–291   
Nambisan, S., Lyytinen, K., Majchrzak, A., & Song, M. (2017). Digital Innovation Management: Reinventing innovation management research in a digital world. Mis Quarterly, 41(1), 223–238   
Nambisan, S., Lyytinen, K., & Yoo, Y. (2020). Handbook of digital innovation Edward Elgar Publishing   
Netflix. (2020). Machine Learning. Retrieved 2020-12-03 from https:// research.netflix.com/research-area/machinelearning   
Ntoutsi, E., Fafalios, P., Gadiraju, U., Iosifidis, V., Nejdl, W., Vidal, M. E., & Krasanakis, E. (2020). Bias in data-driven artificial intelligence systems—An introductory survey. Wiley Interdisciplinary Reviews: Data Mining and Knowledge Discovery, 10(3), e1356   
Nuruzzaman, M., & Hussain, O. K. (2018). A survey on chatbot implementation in customer service industry through deep neural networks. 2018 IEEE 15th International Conference on e-Business Engineering (ICEBE)   
Papagiannidis, E., Mikalef, P., & Krogstie, J. (2021). 2021). Structuring AI resources to build an AI capability: A conceptual framework. European Conference on Information Systems, Marrakesh, Morocco   
Pellikka, J., & Ali-Vehmas, T. (2016). Managing innovation ecosystems to create and capture value in ICT industries. Technology Innovation Management Review, 6(10)   
Plastino, E., & Purdy, M. (2018). Game changing value from Artificial Intelligence: eight strategies. Strategy & Leadership, 46(1), 16–22   
Prentice, C., Lopes, D., Wang, X. S., & &,. (2020). The impact of artificial intelligence and employee service quality on customer satisfaction and loyalty. Journal of Hospitality Marketing & Management, 29(7), 739–756   
Pumplun, L., Tauchert, C., & Heidt, M. (2019b). A new organizational chassis for artificial intelligence-exploring organizational readiness factors. In: Proceedings of the 27th European Conference on Information Systems (ECIS), Stockholm & Uppsala, Sweden   
Quinio, B., Harfouche, A., Skandrani, S. R., & Marciniak, R. (2017). A framework for artificial knowledge creation in organizations. International Conference on Information Systems, Seoul, South Korea   
Rajput, S., & Singh, S. P. (2019). Connecting circular economy and industry 4.0. International Journal of Information Management, 49, 98–113   
Ransbotham, S., Kiron, D., Gerbert, P., & Reeves, M. (2017). Reshaping business with artificial intelligence: Closing the gap between ambition and action. MIT Sloan Management Review, 59(1)   
Ransbotham, S., Gerbert, P., Reeves, M., Kiron, D., & Spira, M. (2018). Artificial intelligence in business gets real. MIT Sloan Management Review   
Riikkinen, M., Saarijärvi, H., Sarlin, P., & Lähteenmäki, I. (2018). Using artificial intelligence to create value in insurance. International Journal of Bank Marketing, 36(6), 1145–1168. https://doi.org/10. 1108/IJBM-01-2017-0015   
Samek, W., & Müller, K. R. (2019). Towards explainable artificial intelligence. In: Explainable AI: interpreting, explaining and visualizing deep learning (pp. 5–22). Springer   
Schaefer, C., Lemmer, K., Samy Kret, K., Ylinen, M., Mikalef, P., & Niehaves, B. (2021). Truth or Dare?–How can we Influence the Adoption of Artificial Intelligence in Municipalities? Proceedings of the 54th Hawaii International Conference on System Sciences   
Schmidt, R., Zimmermann, A., Moehring, M., & Keller, B. (2020). Value creation in connectionist artificial intelligence–A research agenda   
Shollo, A., Aanestad, M., Lyytinen, K., Mahring, M., Nielsen, P. A., & Sørensen, C. (2020). Panel 4: a nordic sociotechnical perspective on artificial intelligence phenomena. Proceedings of the 28th European Conference on Information Systems (ECIS): A Virtual AIS Conference   
Shrestha, Y. R., Ben-Menahem, S. M., & Von Krogh, G. (2019). Organizational decision-making structures in the age of artificial intelligence. California Management Review, 61(4), 66–83   
Tallon, P. P., & Pinsonneault, A. (2011). Competing perspectives on the link between strategic information technology alignment and organizational agility: insights from a mediation model. Mis Quarterly, 35(2), 463–486   
Templier, M., & Paré, G. (2015). A framework for guiding and evaluating literature reviews. Communications of the Association for Information Systems, 37(1), 6   
Toniolo, K., Masiero, E., Massaro, M., & Bagnoli, C. (2020). Sustainable business models and artificial intelligence: Opportunities and challenges. In: In Knowledge, People, and Digital Transformation (pp 103–117). Springer   
Vigdor, N. (2019). Apple card investigated after gender discrimination complaints. The New York Times. Retrieved 15/06 from https:// www.nytimes.com/2019/11/10/business/Apple-credit-cardinvestigation.html   
Wamba-Taguimdje, S. L., Wamba, S. F., Kamdjoug, J. R. K., & Wanko, C. E. T. (2020). Influence of artificial intelligence (AI) on firm performance: the business value of AI-based transformation projects. Business Process Management Journal, 26(7), 1893–1924. https://doi.org/10.1108/BPMJ-10-2019-0411   
Wang, H., Huang, J., & Zhang, Z. (2019). The impact of deep learning on organizational agility. In proceedings of the 40th International Conference on Information Systems (ICIS), Munich, Germany   
Wanner, J., Herm, L. V., Heinrich, K., Janiesch, C., & Zschech, P. (2020). White, Grey, Black: Effects of XAI Augmentation on the Confidence in AI-based Decision Support Systems   
Welling, M. (2019). Artificial intelligence versus intelligence engineering. Harvard Data Science Review, 1(1)   
Yang, W., & Meyer, K. E. (2019). How does ownership influence business growth? A competitive dynamics perspective. International Business Review, 28(5), 101482   
Yudkowsky, E. (2008). Artificial intelligence as a positive and negative factor in global risk. Global Catastrophic Risks, 1(303), 184   
Zheng, N., Liu, Z., Ren, P., Ma, Y., Chen, S., Yu, S., & Wang, F. (2017). Hybrid-augmented intelligence: collaboration and cognition. Frontiers of Information Technology & Electronic Engineering, 18(2), 153–179   
Zuiderveen Borgesius, F. J. (2020). Strengthening legal protection against discrimination by algorithms and artificial intelligence. The International Journal of Human Rights, 24(10), 1572–1593   
Dwivedi, Y. K., Hughes, L., Ismagilova, E., Aarts, G., Coombs, C., Crick, T., ... & Williams, M. D. (2019). Artificial Intelligence (AI): Multidisciplinary perspectives on emerging challenges, opportunities, and agenda for research, practice and policy. International Journal of Information Management, 101994.

Publisher’s Note Springer Nature remains neutral with regard to jurisdictional claims in published maps and institutional affiliations.

Ida Merete Enholm works as a fullstack-developer in Oslo (Norway) building digitalsolutions for a variety of customers. She has received her M.Sc. in ComputerScience from the Norwegian University of Science and Technology (NTNU). HerMaster’s Thesis was focused towards responsible governance of AI.

Emmanouil Papagiannidis is a PhD candidate at the Department of Computer Science. In the past, he has received his B.Sc. in Applied Informatics from the University of Macedonia (UOM), his M.Sc. in Computer Science from the University of Newcastle and his M.Sc. in

Data Science from Newcastle University. Moreover, Manos has worked as a software developer in Greece (Athens) and the United Kingdom (Newcastle) building websites, managing systems and improving or fixing existence code by adding new features and introducing new technologies.

Patrick Mikalef is an Associate Professor in Data Science and Information Systems atthe Department of Computer Science. In the past, he has been a Marie Skłodowska-Curie post-doctoral research fellow working on the research project “Competitive Advantage for the Datadriven Enterprise” (CADENT). He received his B.Sc. in Informatics from the Ionian University, his M.Sc. in Business Informatics for Utrecht University, and his Ph.D. in IT Strategy fromthe Ionian University. His research interests focus the on strategic use of information systems and IT-business value in turbulent environments. He has published work in international conferences and peer-reviewed journals including the

Journal of the Association for Information Systems, British Journal of Management, Information and Management, European Journal of Information Systems, and Information Systems Frontiers.

John Krogstie John Krogstie holds a PhD (1995) and a MSc (1991) in information systems from the Norwegian University of Science and Technology (NTNU), where he is currently a full professor in information systems at the computer science department (IDI). John Krogstie is the Norwegian representative and previously Vice-Chair for IFIP TC8 and was chair of IFIP WG 8.1 on information system design and evaluations (2010-2015). His research interests are information systems modelling, information systems engineering, quality of models and modelling languages, Value of big data and AI, sustainable smart cities and sustainable digitalization in general. He has published more than 350 refereed papers in journals, books and archival proceedings since 1991. H-index as of August 2021 is 53.